/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionConfiguration;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientAccessTypeCondition
implements ClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientAccessTypeCondition.class);
    private Configuration configuration = new Configuration();
    private final KeycloakSession session;

    public ClientAccessTypeCondition(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public boolean isNegativeLogic() {
        return Optional.ofNullable(this.configuration.isNegativeLogic()).orElse(Boolean.FALSE);
    }

    public String getProviderId() {
        return "client-accesstype-condition";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case USERINFO_REQUEST: 
            case LOGOUT_REQUEST: {
                if (this.isClientAccessTypeMatched()) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private String getClientAccessType() {
        ClientModel client = this.session.getContext().getClient();
        if (client == null) {
            return null;
        }
        if (client.isPublicClient()) {
            return "public";
        }
        if (client.isBearerOnly()) {
            return "bearer-only";
        }
        return "confidential";
    }

    private boolean isClientAccessTypeMatched() {
        String accessType = this.getClientAccessType();
        if (accessType == null) {
            return false;
        }
        List expectedAccessTypes = Optional.ofNullable(this.configuration.getType()).orElse(Collections.emptyList());
        if (logger.isTraceEnabled()) {
            logger.tracev("accessType = {0}", (Object)accessType);
            expectedAccessTypes.stream().forEach(i -> logger.tracev("expected accessType = {0}", i));
        }
        return expectedAccessTypes.stream().anyMatch(i -> i.equals(accessType));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration
    extends ClientPolicyConditionConfiguration {
        @JsonProperty(value="is-negative-logic")
        protected Boolean negativeLogic;
        protected List<String> type;

        public Boolean isNegativeLogic() {
            return this.negativeLogic;
        }

        public void setNegativeLogic(Boolean negativeLogic) {
            this.negativeLogic = negativeLogic;
        }

        public List<String> getType() {
            return this.type;
        }

        public void setType(List<String> type) {
            this.type = type;
        }
    }
}

