/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.PKCEEnforceExecutor;

public class PKCEEnforceExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "pkce-enforce-executor";
    public static final String IS_AUGMENT = "is-augment";
    private static final ProviderConfigProperty IS_AUGMENT_PROPERTY = new ProviderConfigProperty("is-augment", null, null, "boolean", (Object)false);

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new PKCEEnforceExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "It makes the client enforce Proof Key for Code Exchange operation.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new ArrayList<ProviderConfigProperty>(Arrays.asList(IS_AUGMENT_PROPERTY));
    }
}

