/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorConfiguration;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureClientAuthEnforceExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureClientAuthEnforceExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-client-authn-executor";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext clientUpdateContext = (ClientCRUDContext)context;
                this.augment(clientUpdateContext.getProposedClientRepresentation());
                this.validate(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            default: {
                return;
            }
        }
    }

    private void augment(ClientRepresentation rep) {
        if (this.configuration.isAugment().booleanValue()) {
            rep.setClientAuthenticatorType(this.enforcedClientAuthenticatorType());
        }
    }

    private void validate(ClientRepresentation rep) throws ClientPolicyException {
        this.verifyClientAuthenticationMethod(rep.getClientAuthenticatorType());
    }

    private String enforcedClientAuthenticatorType() {
        return this.configuration.getClientAuthnsAugment();
    }

    private void verifyClientAuthenticationMethod(String clientAuthenticatorType) throws ClientPolicyException {
        List<String> acceptableClientAuthn = this.configuration.getClientAuthns();
        if (acceptableClientAuthn != null && acceptableClientAuthn.stream().anyMatch(i -> i.equals(clientAuthenticatorType))) {
            return;
        }
        throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: token_endpoint_auth_method");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration
    extends ClientPolicyExecutorConfiguration {
        @JsonProperty(value="client-authns")
        protected List<String> clientAuthns;
        @JsonProperty(value="client-authns-augment")
        protected String clientAuthnsAugment;
        @JsonProperty(value="is-augment")
        protected Boolean augment;

        public List<String> getClientAuthns() {
            return this.clientAuthns;
        }

        public void setClientAuthns(List<String> clientAuthns) {
            this.clientAuthns = clientAuthns;
        }

        public String getClientAuthnsAugment() {
            return this.clientAuthnsAugment;
        }

        public void setClientAuthnsAugment(String clientAuthnsAugment) {
            this.clientAuthnsAugment = clientAuthnsAugment;
        }

        public Boolean isAugment() {
            return this.augment;
        }

        public void setAugment(Boolean augment) {
            this.augment = augment;
        }
    }
}

