/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.context.DynamicClientUpdateContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorConfiguration;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureRedirectUriEnforceExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfiguration> {
    private static final Logger logger = Logger.getLogger(SecureRedirectUriEnforceExecutor.class);
    private final KeycloakSession session;

    public SecureRedirectUriEnforceExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-redirecturi-enforce-executor";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (!(context instanceof AdminClientRegisterContext) && !(context instanceof DynamicClientRegisterContext)) {
                    throw new ClientPolicyException("invalid_request", "not allowed input format.");
                }
                this.confirmSecureRedirectUris(((ClientCRUDContext)context).getProposedClientRepresentation().getRedirectUris());
                return;
            }
            case UPDATE: {
                if (!(context instanceof AdminClientUpdateContext) && !(context instanceof DynamicClientUpdateContext)) {
                    throw new ClientPolicyException("invalid_request", "not allowed input format.");
                }
                this.confirmSecureRedirectUris(((ClientCRUDContext)context).getProposedClientRepresentation().getRedirectUris());
                return;
            }
            case AUTHORIZATION_REQUEST: {
                this.confirmSecureRedirectUris(Arrays.asList(((AuthorizationRequestContext)context).getRedirectUri()));
                return;
            }
        }
    }

    private void confirmSecureRedirectUris(List<String> redirectUris) throws ClientPolicyException {
        if (redirectUris == null || redirectUris.isEmpty()) {
            throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: redirect_uris");
        }
        for (String redirectUri : redirectUris) {
            logger.tracev("Redirect URI = {0}", (Object)redirectUri);
            if (!redirectUri.startsWith("http://") && !redirectUri.contains("*")) continue;
            throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: redirect_uris");
        }
    }
}

