/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.userprofile.LegacyUserProfileProvider;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.UserProfileProviderFactory;

public class LegacyUserProfileProviderFactory
implements UserProfileProviderFactory {
    private static final Logger logger = Logger.getLogger(LegacyUserProfileProviderFactory.class);
    UserProfileProvider provider;
    private Pattern readOnlyAttributesPattern;
    private Pattern adminReadOnlyAttributesPattern;
    private String[] DEFAULT_READ_ONLY_ATTRIBUTES = new String[]{"KERBEROS_PRINCIPAL", "LDAP_ID", "LDAP_ENTRY_DN", "CREATED_TIMESTAMP", "createTimestamp", "modifyTimestamp", "userCertificate", "saml.persistent.name.id.for.*", "ENABLED", "EMAIL_VERIFIED", "disabledReason"};
    private String[] DEFAULT_ADMIN_READ_ONLY_ATTRIBUTES = new String[]{"KERBEROS_PRINCIPAL", "LDAP_ID", "LDAP_ENTRY_DN", "CREATED_TIMESTAMP", "createTimestamp", "modifyTimestamp"};
    public static final String PROVIDER_ID = "legacy-user-profile";

    public UserProfileProvider create(KeycloakSession session) {
        this.provider = new LegacyUserProfileProvider(session, this.readOnlyAttributesPattern, this.adminReadOnlyAttributesPattern);
        return this.provider;
    }

    public void init(Config.Scope config) {
        this.readOnlyAttributesPattern = this.getRegexPatternString(config, "read-only-attributes", this.DEFAULT_READ_ONLY_ATTRIBUTES);
        this.adminReadOnlyAttributesPattern = this.getRegexPatternString(config, "admin-read-only-attributes", this.DEFAULT_ADMIN_READ_ONLY_ATTRIBUTES);
    }

    private Pattern getRegexPatternString(Config.Scope config, String configKey, String[] builtinReadOnlyAttributes) {
        String[] readOnlyAttributesCfg = config.getArray(configKey);
        ArrayList<String> readOnlyAttributes = new ArrayList<String>(Arrays.asList(builtinReadOnlyAttributes));
        if (readOnlyAttributesCfg != null) {
            List<String> configured = Arrays.asList(readOnlyAttributesCfg);
            logger.infof("Configured %s: %s", (Object)configKey, configured);
            readOnlyAttributes.addAll(configured);
        }
        String regexStr = readOnlyAttributes.stream().map(configAttrName -> configAttrName.endsWith("*") ? "^" + Pattern.quote(configAttrName.substring(0, configAttrName.length() - 1)) + ".*$" : "^" + Pattern.quote(configAttrName) + "$").collect(Collectors.joining("|"));
        regexStr = "(?i:" + regexStr + ")";
        logger.debugf("Regex used for %s: %s", (Object)configKey, (Object)regexStr);
        return Pattern.compile(regexStr);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

