/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.profile;

import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.AttributeFormDataProcessor;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.profile.DefaultUserProfileContext;
import org.keycloak.userprofile.profile.representations.AccountUserRepresentationUserProfile;
import org.keycloak.userprofile.profile.representations.IdpUserProfile;
import org.keycloak.userprofile.profile.representations.UserModelUserProfile;
import org.keycloak.userprofile.profile.representations.UserRepresentationUserProfile;
import org.keycloak.userprofile.validation.UserUpdateEvent;

public final class UserProfileContextFactory {
    public static DefaultUserProfileContext forIdpReview(SerializedBrokeredIdentityContext currentUser, MultivaluedMap<String, String> formData, KeycloakSession session) {
        UserProfileProvider profileProvider = UserProfileContextFactory.getProfileProvider(session);
        return new DefaultUserProfileContext(UserUpdateEvent.IdpReview, new IdpUserProfile(currentUser, profileProvider), AttributeFormDataProcessor.toUserProfile(formData), profileProvider);
    }

    public static DefaultUserProfileContext forUpdateProfile(UserModel currentUser, MultivaluedMap<String, String> formData, KeycloakSession session) {
        UserProfileProvider profileProvider = UserProfileContextFactory.getProfileProvider(session);
        return new DefaultUserProfileContext(UserUpdateEvent.UpdateProfile, new UserModelUserProfile(currentUser, profileProvider), AttributeFormDataProcessor.toUserProfile(formData), profileProvider);
    }

    public static DefaultUserProfileContext forAccountService(UserModel currentUser, org.keycloak.representations.account.UserRepresentation rep, KeycloakSession session) {
        UserProfileProvider profileProvider = UserProfileContextFactory.getProfileProvider(session);
        return new DefaultUserProfileContext(UserUpdateEvent.Account, new UserModelUserProfile(currentUser, profileProvider), new AccountUserRepresentationUserProfile(rep, profileProvider), profileProvider);
    }

    public static DefaultUserProfileContext forOldAccount(UserModel currentUser, MultivaluedMap<String, String> formData, KeycloakSession session) {
        UserProfileProvider profileProvider = UserProfileContextFactory.getProfileProvider(session);
        return new DefaultUserProfileContext(UserUpdateEvent.Account, new UserModelUserProfile(currentUser, profileProvider), AttributeFormDataProcessor.toUserProfile(formData), profileProvider);
    }

    public static DefaultUserProfileContext forRegistrationUserCreation(KeycloakSession session, MultivaluedMap<String, String> formData) {
        UserProfileProvider profileProvider = UserProfileContextFactory.getProfileProvider(session);
        return new DefaultUserProfileContext(UserUpdateEvent.RegistrationUserCreation, null, AttributeFormDataProcessor.toUserProfile(formData), profileProvider);
    }

    public static DefaultUserProfileContext forRegistrationProfile(KeycloakSession session, MultivaluedMap<String, String> formData) {
        UserProfileProvider profileProvider = UserProfileContextFactory.getProfileProvider(session);
        return new DefaultUserProfileContext(UserUpdateEvent.RegistrationProfile, null, AttributeFormDataProcessor.toUserProfile(formData), profileProvider);
    }

    public static DefaultUserProfileContext forUserResource(UserModel currentUser, UserRepresentation rep, KeycloakSession session) {
        UserProfileProvider profileProvider = UserProfileContextFactory.getProfileProvider(session);
        UserModelUserProfile currentUserProfile = currentUser == null ? null : new UserModelUserProfile(currentUser, profileProvider);
        return new DefaultUserProfileContext(UserUpdateEvent.UserResource, currentUserProfile, new UserRepresentationUserProfile(rep, profileProvider), profileProvider);
    }

    public static DefaultUserProfileContext forProfile(UserUpdateEvent event) {
        return new DefaultUserProfileContext(event, null, null, null);
    }

    private static UserProfileProvider getProfileProvider(KeycloakSession session) {
        if (session == null) {
            return null;
        }
        return (UserProfileProvider)session.getProvider(UserProfileProvider.class, "legacy-user-profile");
    }
}

