/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.authentication.authenticators.x509.AbstractX509ClientCertificateAuthenticator;
import org.keycloak.authentication.authenticators.x509.CertificateValidator;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;

public class X509ClientCertificateAuthenticator
extends AbstractX509ClientCertificateAuthenticator {
    @Override
    public void close() {
    }

    public void authenticate(AuthenticationFlowContext context) {
        try {
            UserModel user;
            this.dumpContainerAttributes(context);
            X509Certificate[] certs = this.getCertificateChain(context);
            if (certs == null || certs.length == 0) {
                logger.debug("[X509ClientCertificateAuthenticator:authenticate] x509 client certificate is not available for mutual SSL.");
                context.attempted();
                return;
            }
            this.saveX509CertificateAuditDataToAuthSession(context, certs[0]);
            this.recordX509CertificateAuditDataViaContextEvent(context);
            X509AuthenticatorConfigModel config = null;
            if (context.getAuthenticatorConfig() != null && context.getAuthenticatorConfig().getConfig() != null) {
                config = new X509AuthenticatorConfigModel(context.getAuthenticatorConfig());
            }
            if (config == null) {
                logger.warn("[X509ClientCertificateAuthenticator:authenticate] x509 Client Certificate Authentication configuration is not available.");
                context.challenge(this.createInfoResponse(context, "X509 client authentication has not been configured yet", new Object[0]));
                context.attempted();
                return;
            }
            try {
                CertificateValidator.CertificateValidatorBuilder builder = this.certificateValidationParameters(context.getSession(), config);
                CertificateValidator validator = builder.build(certs);
                validator.checkRevocationStatus().validateKeyUsage().validateExtendedKeyUsage().validateTimestamps();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                String errorMessage = "Certificate validation's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, e.getMessage()));
                context.attempted();
                return;
            }
            Object userIdentity = this.getUserIdentityExtractor(config).extractUserIdentity(certs);
            if (userIdentity == null) {
                context.getEvent().error("invalid_user_credentials");
                logger.warnf("[X509ClientCertificateAuthenticator:authenticate] Unable to extract user identity from certificate.", new Object[0]);
                String errorMessage = "Unable to extract user identity from specified certificate";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, new String[0]));
                context.attempted();
                return;
            }
            try {
                context.getEvent().detail("username", userIdentity.toString());
                context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", userIdentity.toString());
                user = this.getUserIdentityToModelMapper(config).find(context, userIdentity);
            }
            catch (ModelDuplicateException e) {
                logger.modelDuplicateException(e);
                String errorMessage = "X509 certificate authentication's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, e.getMessage()));
                context.attempted();
                return;
            }
            if (this.invalidUser(context, user)) {
                String errorMessage = "X509 certificate authentication's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, "Invalid user"));
                context.attempted();
                return;
            }
            String bruteForceError = AuthenticatorUtils.getDisabledByBruteForceEventError(context.getProtector(), context.getSession(), context.getRealm(), user);
            if (bruteForceError != null) {
                context.getEvent().user(user);
                context.getEvent().error(bruteForceError);
                String errorMessage = "X509 certificate authentication's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, "Invalid user"));
                context.attempted();
                return;
            }
            if (!this.userEnabled(context, user)) {
                String errorMessage = "X509 certificate authentication's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, "User is disabled"));
                context.attempted();
                return;
            }
            context.setUser(user);
            if (!config.getConfirmationPageDisallowed()) {
                context.forceChallenge(this.createSuccessResponse(context, certs[0].getSubjectDN().getName()));
            } else {
                context.success();
            }
        }
        catch (Exception e) {
            logger.errorf("[X509ClientCertificateAuthenticator:authenticate] Exception: %s", e.getMessage());
            context.attempted();
        }
    }

    private Response createErrorResponse(AuthenticationFlowContext context, String subjectDN, String errorMessage, String ... errorParameters) {
        return this.createResponse(context, subjectDN, false, errorMessage, errorParameters);
    }

    private Response createSuccessResponse(AuthenticationFlowContext context, String subjectDN) {
        return this.createResponse(context, subjectDN, true, null, null);
    }

    private Response createResponse(AuthenticationFlowContext context, String subjectDN, boolean isUserEnabled, String errorMessage, Object[] errorParameters) {
        LoginFormsProvider form = context.form();
        if (errorMessage != null && errorMessage.trim().length() > 0) {
            LinkedList<FormMessage> errors = new LinkedList<FormMessage>();
            errors.add(new FormMessage(errorMessage, new Object[0]));
            if (errorParameters != null) {
                for (Object errorParameter : errorParameters) {
                    if (errorParameter == null) continue;
                    for (String part : errorParameter.toString().split("\n")) {
                        errors.add(new FormMessage(part, new Object[0]));
                    }
                }
            }
            form.setErrors(errors);
        }
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"username", (Object)(context.getUser() != null ? context.getUser().getUsername() : "unknown user"));
        formData.add((Object)"subjectDN", (Object)subjectDN);
        formData.add((Object)"isUserEnabled", (Object)String.valueOf(isUserEnabled));
        form.setFormData((MultivaluedMap)formData);
        return form.createX509ConfirmPage();
    }

    private void dumpContainerAttributes(AuthenticationFlowContext context) {
        Enumeration attributeNames = context.getHttpRequest().getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String a = (String)attributeNames.nextElement();
            logger.tracef("[X509ClientCertificateAuthenticator:dumpContainerAttributes] \"%s\"", a);
        }
    }

    private boolean userEnabled(AuthenticationFlowContext context, UserModel user) {
        if (!user.isEnabled()) {
            context.getEvent().user(user);
            context.getEvent().error("user_disabled");
            return false;
        }
        return true;
    }

    private boolean invalidUser(AuthenticationFlowContext context, UserModel user) {
        if (user == null) {
            context.getEvent().error("user_not_found");
            return true;
        }
        return false;
    }

    public void action(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"cancel")) {
            context.clearUser();
            context.attempted();
            return;
        }
        if (context.getUser() != null) {
            this.recordX509CertificateAuditDataViaContextEvent(context);
            context.success();
            return;
        }
        context.attempted();
    }
}

