/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class RegistrationProfile
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-profile-action";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "Validates email, first name, and last name attributes and stores them in user data.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        context.getEvent().detail("register_method", "form");
        UserProfileProvider profileProvider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
        UserProfile profile = profileProvider.create(UserProfileContext.REGISTRATION_PROFILE, (Map)formData);
        try {
            profile.validate();
        }
        catch (ValidationException pve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(pve.getErrors());
            if (pve.hasError(new String[]{"emailExistsMessage", "invalidEmailMessage"})) {
                context.getEvent().detail("email", profile.getAttributes().getFirstValue("email"));
            }
            if (pve.hasError(new String[]{"emailExistsMessage"})) {
                context.error("email_in_use");
            } else {
                context.error("invalid_registration");
            }
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    public void success(FormContext context) {
        UserModel user = context.getUser();
        UserProfileProvider provider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
        provider.create(UserProfileContext.REGISTRATION_PROFILE, (Map)context.getHttpRequest().getDecodedFormParameters(), user).update(new BiConsumer[0]);
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Profile Validation";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

