/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.theme.KeycloakSanitizerPolicy;
import org.owasp.html.PolicyFactory;

public class KeycloakSanitizerMethod
implements TemplateMethodModelEx {
    private static final PolicyFactory KEYCLOAK_POLICY = KeycloakSanitizerPolicy.POLICY_DEFINITION;

    public Object exec(List list) throws TemplateModelException {
        if (list.isEmpty() || list.get(0) == null) {
            throw new NullPointerException("Can not escape null value.");
        }
        String html = list.get(0).toString();
        String sanitized = KEYCLOAK_POLICY.sanitize(html);
        return this.fixURLs(sanitized);
    }

    private String fixURLs(String msg) {
        Pattern hrefs = Pattern.compile("href=\"([^\"]*)\"");
        Matcher matcher = hrefs.matcher(msg);
        int count = 0;
        while (matcher.find()) {
            String original = matcher.group(++count);
            String href = original.replaceAll("&#61;", "=").replaceAll("\\.\\.", ".").replaceAll("&amp;", "&");
            msg = msg.replace(original, href);
        }
        return msg;
    }
}

