/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.util.PathMatcher;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ResourceSetService {
    private final AuthorizationProvider authorization;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private KeycloakSession session;
    private ResourceServer resourceServer;

    public ResourceSetService(KeycloakSession session, ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.AUTHORIZATION_RESOURCE);
    }

    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPost(ResourceRepresentation resource) {
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ResourceRepresentation newResource = this.create(resource);
        this.audit(resource, resource.getId(), OperationType.CREATE);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)newResource).build();
    }

    public ResourceRepresentation create(ResourceRepresentation resource) {
        String ownerId;
        this.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceOwnerRepresentation owner = resource.getOwner();
        if (owner == null) {
            owner = new ResourceOwnerRepresentation();
            owner.setId(this.resourceServer.getId());
            resource.setOwner(owner);
        }
        if ((ownerId = owner.getId()) == null) {
            throw new ErrorResponseException("invalid_request", "You must specify the resource owner.", Response.Status.BAD_REQUEST);
        }
        Resource existingResource = storeFactory.getResourceStore().findByName(resource.getName(), ownerId, this.resourceServer.getId());
        if (existingResource != null) {
            throw new ErrorResponseException("invalid_request", "Resource with name [" + resource.getName() + "] already exists.", Response.Status.CONFLICT);
        }
        return ModelToRepresentation.toRepresentation((Resource)RepresentationToModel.toModel((ResourceRepresentation)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization), (String)this.resourceServer.getId(), (AuthorizationProvider)this.authorization);
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="id") String id, ResourceRepresentation resource) {
        this.requireManage();
        resource.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        Resource model = resourceStore.findById(resource.getId(), this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        RepresentationToModel.toModel((ResourceRepresentation)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        this.audit(resource, OperationType.UPDATE);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource resource = storeFactory.getResourceStore().findById(id, this.resourceServer.getId());
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        storeFactory.getResourceStore().delete(id);
        this.audit(ModelToRepresentation.toRepresentation((Resource)resource, (String)this.resourceServer.getId(), (AuthorizationProvider)this.authorization), OperationType.DELETE);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        return this.findById(id, resource -> ModelToRepresentation.toRepresentation((Resource)resource, (String)this.resourceServer.getId(), (AuthorizationProvider)this.authorization, (Boolean)true));
    }

    public Response findById(String id, Function<Resource, ? extends ResourceRepresentation> toRepresentation) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource model = storeFactory.getResourceStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)toRepresentation.apply(model)).build();
    }

    @Path(value="{id}/scopes")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getScopes(@PathParam(value="id") String id) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource model = storeFactory.getResourceStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List scopes = model.getScopes().stream().map(scope -> {
            ScopeRepresentation representation = new ScopeRepresentation();
            representation.setId(scope.getId());
            representation.setName(scope.getName());
            return representation;
        }).collect(Collectors.toList());
        if (model.getType() != null && !model.getOwner().equals(this.resourceServer.getId())) {
            ResourceStore resourceStore = this.authorization.getStoreFactory().getResourceStore();
            for (Resource typed : resourceStore.findByType(model.getType(), this.resourceServer.getId())) {
                if (!typed.getOwner().equals(this.resourceServer.getId()) || typed.getId().equals(model.getId())) continue;
                scopes.addAll(typed.getScopes().stream().map(model1 -> {
                    ScopeRepresentation scope = new ScopeRepresentation();
                    scope.setId(model1.getId());
                    scope.setName(model1.getName());
                    String iconUri = model1.getIconUri();
                    if (iconUri != null) {
                        scope.setIconUri(iconUri);
                    }
                    return scope;
                }).filter(scopeRepresentation -> !scopes.contains(scopeRepresentation)).collect(Collectors.toList()));
            }
        }
        return Response.ok(scopes).build();
    }

    @Path(value="{id}/permissions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getPermissions(@PathParam(value="id") String id) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        Resource model = resourceStore.findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyStore policyStore = this.authorization.getStoreFactory().getPolicyStore();
        HashSet policies = new HashSet();
        policies.addAll(policyStore.findByResource(model.getId(), this.resourceServer.getId()));
        if (model.getType() != null) {
            policies.addAll(policyStore.findByResourceType(model.getType(), this.resourceServer.getId()));
            EnumMap<Resource.FilterOption, String[]> resourceFilter = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
            resourceFilter.put(Resource.FilterOption.OWNER, new String[]{this.resourceServer.getId()});
            resourceFilter.put(Resource.FilterOption.TYPE, new String[]{model.getType()});
            for (Resource resourceType : resourceStore.findByResourceServer(resourceFilter, this.resourceServer.getId(), -1, -1)) {
                policies.addAll(policyStore.findByResource(resourceType.getId(), this.resourceServer.getId()));
            }
        }
        policies.addAll(policyStore.findByScopeIds(model.getScopes().stream().map(scope -> scope.getId()).collect(Collectors.toList()), id, this.resourceServer.getId()));
        policies.addAll(policyStore.findByScopeIds(model.getScopes().stream().map(scope -> scope.getId()).collect(Collectors.toList()), null, this.resourceServer.getId()));
        ArrayList<PolicyRepresentation> representation = new ArrayList<PolicyRepresentation>();
        for (Policy policyModel : policies) {
            if ("uma".equalsIgnoreCase(policyModel.getType())) continue;
            PolicyRepresentation policy = new PolicyRepresentation();
            policy.setId(policyModel.getId());
            policy.setName(policyModel.getName());
            policy.setType(policyModel.getType());
            if (representation.contains(policy)) continue;
            representation.add(policy);
        }
        return Response.ok(representation).build();
    }

    @Path(value="{id}/attributes")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getAttributes(@PathParam(value="id") String id) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource model = storeFactory.getResourceStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)model.getAttributes()).build();
    }

    @Path(value="/search")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response find(@QueryParam(value="name") String name) {
        this.auth.realm().requireViewAuthorization();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Resource model = storeFactory.getResourceStore().findByName(name, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Resource)model, (String)this.resourceServer.getId(), (AuthorizationProvider)this.authorization)).build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response find(@QueryParam(value="_id") String id, @QueryParam(value="name") String name, @QueryParam(value="uri") String uri, @QueryParam(value="owner") String owner, @QueryParam(value="type") String type, @QueryParam(value="scope") String scope, @QueryParam(value="matchingUri") Boolean matchingUri, @QueryParam(value="exactName") Boolean exactName, @QueryParam(value="deep") Boolean deep, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        return this.find(id, name, uri, owner, type, scope, matchingUri, exactName, deep, firstResult, maxResult, (resource, deep1) -> ModelToRepresentation.toRepresentation((Resource)resource, (String)this.resourceServer.getId(), (AuthorizationProvider)this.authorization, (Boolean)deep1));
    }

    public Response find(@QueryParam(value="_id") String id, @QueryParam(value="name") String name, @QueryParam(value="uri") String uri, @QueryParam(value="owner") String owner, @QueryParam(value="type") String type, @QueryParam(value="scope") String scope, @QueryParam(value="matchingUri") Boolean matchingUri, @QueryParam(value="exactName") Boolean exactName, @QueryParam(value="deep") Boolean deep, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult, BiFunction<Resource, Boolean, ?> toRepresentation) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (deep == null) {
            deep = true;
        }
        EnumMap<Resource.FilterOption, String[]> search = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
        if (id != null && !"".equals(id.trim())) {
            search.put(Resource.FilterOption.ID, new String[]{id});
        }
        if (name != null && !"".equals(name.trim())) {
            search.put(exactName != null && exactName != false ? Resource.FilterOption.EXACT_NAME : Resource.FilterOption.NAME, new String[]{name});
        }
        if (uri != null && !"".equals(uri.trim())) {
            search.put(Resource.FilterOption.URI, new String[]{uri});
        }
        if (owner != null && !"".equals(owner.trim())) {
            RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
            ClientModel clientModel = realm.getClientByClientId(owner);
            if (clientModel != null) {
                owner = clientModel.getId();
            } else {
                UserModel user = this.authorization.getKeycloakSession().users().getUserByUsername(realm, owner);
                if (user != null) {
                    owner = user.getId();
                }
            }
            search.put(Resource.FilterOption.OWNER, new String[]{owner});
        }
        if (type != null && !"".equals(type.trim())) {
            search.put(Resource.FilterOption.TYPE, new String[]{type});
        }
        if (scope != null && !"".equals(scope.trim())) {
            EnumMap<Scope.FilterOption, String[]> scopeFilter = new EnumMap<Scope.FilterOption, String[]>(Scope.FilterOption.class);
            scopeFilter.put(Scope.FilterOption.NAME, new String[]{scope});
            List scopes = this.authorization.getStoreFactory().getScopeStore().findByResourceServer(scopeFilter, this.resourceServer.getId(), -1, -1);
            if (scopes.isEmpty()) {
                return Response.ok(Collections.emptyList()).build();
            }
            search.put(Resource.FilterOption.SCOPE_ID, (String[])scopes.stream().map(Scope::getId).toArray(String[]::new));
        }
        List resources = storeFactory.getResourceStore().findByResourceServer(search, this.resourceServer.getId(), firstResult != null ? firstResult : -1, maxResult != null ? maxResult : 100);
        if (matchingUri != null && matchingUri.booleanValue() && resources.isEmpty()) {
            EnumMap<Resource.FilterOption, String[]> attributes = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
            attributes.put(Resource.FilterOption.URI_NOT_NULL, new String[]{"true"});
            attributes.put(Resource.FilterOption.OWNER, new String[]{this.resourceServer.getId()});
            final List serverResources = storeFactory.getResourceStore().findByResourceServer(attributes, this.resourceServer.getId(), firstResult != null ? firstResult : -1, maxResult != null ? maxResult : -1);
            PathMatcher<Map.Entry<String, Resource>> pathMatcher = new PathMatcher<Map.Entry<String, Resource>>(){

                protected String getPath(Map.Entry<String, Resource> entry) {
                    return entry.getKey();
                }

                protected Collection<Map.Entry<String, Resource>> getPaths() {
                    HashMap result = new HashMap();
                    serverResources.forEach(resource -> resource.getUris().forEach(uri -> result.put(uri, resource)));
                    return result.entrySet();
                }
            };
            Map.Entry matches = (Map.Entry)pathMatcher.matches(uri);
            if (matches != null) {
                resources = Collections.singletonList(matches.getValue());
            }
        }
        Boolean finalDeep = deep;
        return Response.ok(resources.stream().map(resource -> toRepresentation.apply((Resource)resource, finalDeep)).collect(Collectors.toList())).build();
    }

    private void requireView() {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
    }

    private void requireManage() {
        if (this.auth != null) {
            this.auth.realm().requireManageAuthorization();
        }
    }

    private void audit(ResourceRepresentation resource, OperationType operation) {
        this.audit(resource, null, operation);
    }

    public void audit(ResourceRepresentation resource, String id, OperationType operation) {
        if (id != null) {
            this.adminEvent.operation(operation).resourcePath((UriInfo)this.session.getContext().getUri(), id).representation(resource).success();
        } else {
            this.adminEvent.operation(operation).resourcePath((UriInfo)this.session.getContext().getUri()).representation(resource).success();
        }
    }
}

