/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpointChecker;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequestParserProcessor;
import org.keycloak.protocol.oidc.grants.device.endpoints.DeviceEndpoint;
import org.keycloak.protocol.oidc.utils.AcrUtils;
import org.keycloak.protocol.oidc.utils.OIDCRedirectUriBuilder;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.util.TokenUtil;

public class AuthorizationEndpoint
extends AuthorizationEndpointBase {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpoint.class);
    public static final String CODE_AUTH_TYPE = "code";
    public static final String LOGIN_SESSION_NOTE_ADDITIONAL_REQ_PARAMS_PREFIX = "client_request_param_";
    private ClientModel client;
    private AuthenticationSessionModel authenticationSession;
    private Action action;
    private OIDCResponseType parsedResponseType;
    private OIDCResponseMode parsedResponseMode;
    private AuthorizationEndpointRequest request;
    private String redirectUri;

    public AuthorizationEndpoint(RealmModel realm, EventBuilder event) {
        super(realm, event);
        event.event(EventType.LOGIN);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response buildPost() {
        logger.trace((Object)"Processing @POST request");
        return this.process((MultivaluedMap<String, String>)this.httpRequest.getDecodedFormParameters());
    }

    @GET
    public Response buildGet() {
        logger.trace((Object)"Processing @GET request");
        return this.process((MultivaluedMap<String, String>)this.session.getContext().getUri().getQueryParameters());
    }

    @Path(value="device")
    public Object authorizeDevice() {
        DeviceEndpoint endpoint = new DeviceEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    private Response process(MultivaluedMap<String, String> params) {
        String clientId = AuthorizationEndpointRequestParserProcessor.getClientId(this.event, this.session, params);
        this.checkSsl();
        this.checkRealm();
        this.checkClient(clientId);
        this.request = AuthorizationEndpointRequestParserProcessor.parseRequest(this.event, this.session, this.client, params);
        AuthorizationEndpointChecker checker = new AuthorizationEndpointChecker().event(this.event).client(this.client).realm(this.realm).request(this.request).session(this.session).params(params);
        try {
            checker.checkRedirectUri();
            this.redirectUri = checker.getRedirectUri();
        }
        catch (AuthorizationEndpointChecker.AuthorizationCheckException ex) {
            ex.throwAsErrorPageException(this.authenticationSession);
        }
        try {
            checker.checkResponseType();
            this.parsedResponseType = checker.getParsedResponseType();
            this.parsedResponseMode = checker.getParsedResponseMode();
        }
        catch (AuthorizationEndpointChecker.AuthorizationCheckException ex) {
            OIDCResponseMode responseMode = null;
            responseMode = checker.isInvalidResponseType(ex) ? OIDCResponseMode.parseWhenInvalidResponseType(this.request.getResponseMode()) : (checker.getParsedResponseMode() != null ? checker.getParsedResponseMode() : OIDCResponseMode.QUERY);
            return this.redirectErrorToClient(responseMode, ex.getError(), ex.getErrorDescription());
        }
        if (this.action == null) {
            this.action = Action.CODE;
        }
        try {
            checker.checkParRequired();
            checker.checkInvalidRequestMessage();
            checker.checkOIDCRequest();
            checker.checkValidScope();
            checker.checkOIDCParams();
            checker.checkPKCEParams();
        }
        catch (AuthorizationEndpointChecker.AuthorizationCheckException ex) {
            return this.redirectErrorToClient(this.parsedResponseMode, ex.getError(), ex.getErrorDescription());
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new AuthorizationRequestContext(this.parsedResponseType, this.request, this.redirectUri, params));
        }
        catch (ClientPolicyException cpe) {
            return this.redirectErrorToClient(this.parsedResponseMode, cpe.getError(), cpe.getErrorDetail());
        }
        this.authenticationSession = this.createAuthenticationSession(this.client, this.request.getState());
        this.updateAuthenticationSession();
        CacheControlUtil.noBackButtonCacheControlHeader();
        switch (this.action) {
            case REGISTER: {
                return this.buildRegister();
            }
            case FORGOT_CREDENTIALS: {
                return this.buildForgotCredential();
            }
            case CODE: {
                return this.buildAuthorizationCodeAuthorizationResponse();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    public AuthorizationEndpoint register() {
        this.event.event(EventType.REGISTER);
        this.action = Action.REGISTER;
        if (!this.realm.isRegistrationAllowed()) {
            throw new ErrorPageException(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "registrationNotAllowedMessage", new Object[0]);
        }
        return this;
    }

    public AuthorizationEndpoint forgotCredentials() {
        this.event.event(EventType.RESET_PASSWORD);
        this.action = Action.FORGOT_CREDENTIALS;
        if (!this.realm.isResetPasswordAllowed()) {
            throw new ErrorPageException(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "resetCredentialNotAllowedMessage", new Object[0]);
        }
        return this;
    }

    private void checkClient(String clientId) {
        if (clientId == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "missingParameterMessage", "client_id");
        }
        this.event.client(clientId);
        this.client = this.realm.getClientByClientId(clientId);
        if (this.client == null) {
            this.event.error("client_not_found");
            throw new ErrorPageException(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]);
        }
        if (!this.client.isEnabled()) {
            this.event.error("client_disabled");
            throw new ErrorPageException(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "clientDisabledMessage", new Object[0]);
        }
        if (this.client.isBearerOnly()) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, this.authenticationSession, Response.Status.FORBIDDEN, "bearerOnlyMessage", new Object[0]);
        }
        String protocol = this.client.getProtocol();
        if (protocol == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)clientId);
            protocol = "openid-connect";
        }
        if (!protocol.equals("openid-connect")) {
            this.event.error("invalid_client");
            throw new ErrorPageException(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "Wrong client protocol.", new Object[0]);
        }
        this.session.getContext().setClient(this.client);
    }

    private Response redirectErrorToClient(OIDCResponseMode responseMode, String error, String errorDescription) {
        OIDCRedirectUriBuilder errorResponseBuilder = OIDCRedirectUriBuilder.fromUri(this.redirectUri, responseMode, this.session, null).addParam("error", error);
        if (errorDescription != null) {
            errorResponseBuilder.addParam("error_description", errorDescription);
        }
        if (this.request.getState() != null) {
            errorResponseBuilder.addParam("state", this.request.getState());
        }
        return errorResponseBuilder.build();
    }

    private void updateAuthenticationSession() {
        this.authenticationSession.setProtocol("openid-connect");
        this.authenticationSession.setRedirectUri(this.redirectUri);
        this.authenticationSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        this.authenticationSession.setClientNote("response_type", this.request.getResponseType());
        this.authenticationSession.setClientNote("redirect_uri", this.request.getRedirectUriParam());
        this.authenticationSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        if (this.request.getState() != null) {
            this.authenticationSession.setClientNote("state", this.request.getState());
        }
        if (this.request.getNonce() != null) {
            this.authenticationSession.setClientNote("nonce", this.request.getNonce());
        }
        if (this.request.getMaxAge() != null) {
            this.authenticationSession.setClientNote("max_age", String.valueOf(this.request.getMaxAge()));
        }
        if (this.request.getScope() != null) {
            this.authenticationSession.setClientNote("scope", this.request.getScope());
        }
        if (this.request.getLoginHint() != null) {
            this.authenticationSession.setClientNote("login_hint", this.request.getLoginHint());
        }
        if (this.request.getPrompt() != null) {
            this.authenticationSession.setClientNote("prompt", this.request.getPrompt());
        }
        if (this.request.getIdpHint() != null) {
            this.authenticationSession.setClientNote("kc_idp_hint", this.request.getIdpHint());
        }
        if (this.request.getAction() != null) {
            this.authenticationSession.setClientNote("kc_action", this.request.getAction());
        }
        if (this.request.getResponseMode() != null) {
            this.authenticationSession.setClientNote("response_mode", this.request.getResponseMode());
        }
        if (this.request.getClaims() != null) {
            this.authenticationSession.setClientNote("claims", this.request.getClaims());
        }
        if (this.request.getAcr() != null) {
            this.authenticationSession.setClientNote("acr_values", this.request.getAcr());
        }
        if (this.request.getDisplay() != null) {
            this.authenticationSession.setAuthNote("display", this.request.getDisplay());
        }
        if (this.request.getUiLocales() != null) {
            this.authenticationSession.setAuthNote("locale_client_requested", this.request.getUiLocales());
        }
        if (this.request.getCodeChallenge() != null) {
            this.authenticationSession.setClientNote("code_challenge", this.request.getCodeChallenge());
        }
        if (this.request.getCodeChallengeMethod() != null) {
            this.authenticationSession.setClientNote("code_challenge_method", this.request.getCodeChallengeMethod());
        }
        Map<String, Integer> acrLoaMap = AcrUtils.getAcrLoaMap(this.authenticationSession.getClient());
        List<String> acrValues = AcrUtils.getRequiredAcrValues(this.request.getClaims());
        if (acrValues.isEmpty()) {
            acrValues = AcrUtils.getAcrValues(this.request.getClaims(), this.request.getAcr(), this.authenticationSession.getClient());
        } else {
            this.authenticationSession.setClientNote("force-level-of-authentication", "true");
        }
        acrValues.stream().mapToInt(acr -> {
            try {
                Integer loa = (Integer)acrLoaMap.get(acr);
                return loa == null ? Integer.parseInt(acr) : loa;
            }
            catch (NumberFormatException e) {
                boolean essential = Boolean.parseBoolean(this.authenticationSession.getClientNote("force-level-of-authentication"));
                if (essential) {
                    logger.errorf("Requested essential acr value '%s' is not a number and it is not mapped in the ACR-To-Loa mappings of realm or client. Please doublecheck ACR-to-LOA mapping or correct ACR passed in the 'claims' parameter.", acr);
                    this.event.error("invalid_request");
                    throw new ErrorPageException(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "invalidParameterMessage", "claims");
                }
                logger.warnf("Requested acr value '%s' is not a number and it is not mapped in the ACR-To-Loa mappings of realm or client. Please doublecheck ACR-to-LOA mapping or correct used ACR.", acr);
                return 0;
            }
        }).min().ifPresent(loa -> this.authenticationSession.setClientNote("requested-level-of-authentication", String.valueOf(loa)));
        if (this.request.getAdditionalReqParams() != null) {
            for (String paramName : this.request.getAdditionalReqParams().keySet()) {
                this.authenticationSession.setClientNote(LOGIN_SESSION_NOTE_ADDITIONAL_REQ_PARAMS_PREFIX + paramName, this.request.getAdditionalReqParams().get(paramName));
            }
        }
    }

    private Response buildAuthorizationCodeAuthorizationResponse() {
        this.event.event(EventType.LOGIN);
        this.authenticationSession.setAuthNote("auth_type", CODE_AUTH_TYPE);
        return this.handleBrowserAuthenticationRequest(this.authenticationSession, new OIDCLoginProtocol(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.headers, this.event), TokenUtil.hasPrompt((String)this.request.getPrompt(), (String)"none"), false);
    }

    private Response buildRegister() {
        AuthenticationManager.expireIdentityCookie(this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection);
        AuthenticationFlowModel flow = this.realm.getRegistrationFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(this.authenticationSession, flowId, "registration");
        this.authenticationSession.setClientNote("APP_INITIATED_FLOW", "registration");
        return processor.authenticate();
    }

    private Response buildForgotCredential() {
        AuthenticationManager.expireIdentityCookie(this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection);
        AuthenticationFlowModel flow = this.realm.getResetCredentialsFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(this.authenticationSession, flowId, "reset-credentials");
        this.authenticationSession.setClientNote("APP_INITIATED_FLOW", "reset-credentials");
        return processor.authenticate();
    }

    private static enum Action {
        REGISTER,
        CODE,
        FORGOT_CREDENTIALS;

    }
}

