/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientProfilesResource {
    protected static final Logger logger = Logger.getLogger(ClientProfilesResource.class);
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;

    public ClientProfilesResource(RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ClientProfilesRepresentation getProfiles(@QueryParam(value="include-global-profiles") boolean includeGlobalProfiles) {
        this.auth.realm().requireViewRealm();
        try {
            return this.session.clientPolicy().getClientProfiles(this.realm, includeGlobalProfiles);
        }
        catch (ClientPolicyException e) {
            throw new BadRequestException(ErrorResponse.error(e.getError(), Response.Status.BAD_REQUEST));
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateProfiles(ClientProfilesRepresentation clientProfiles) {
        this.auth.realm().requireManageRealm();
        try {
            this.session.clientPolicy().updateClientProfiles(this.realm, clientProfiles);
        }
        catch (ClientPolicyException e) {
            return ErrorResponse.error(e.getError(), Response.Status.BAD_REQUEST);
        }
        return Response.noContent().build();
    }
}

