/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.endpoints;

import javax.ws.rs.Path;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.ext.OIDCExtProvider;
import org.keycloak.protocol.oidc.ext.OIDCExtProviderFactory;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.BackchannelAuthenticationCallbackEndpoint;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.BackchannelAuthenticationEndpoint;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class CibaRootEndpoint
implements OIDCExtProvider,
OIDCExtProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "ciba";
    private final KeycloakSession session;
    private EventBuilder event;

    public CibaRootEndpoint() {
        this(null);
    }

    public CibaRootEndpoint(KeycloakSession session) {
        this.session = session;
    }

    @Path(value="/auth")
    public BackchannelAuthenticationEndpoint authorize() {
        BackchannelAuthenticationEndpoint endpoint = new BackchannelAuthenticationEndpoint(this.session, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="/auth/callback")
    public BackchannelAuthenticationCallbackEndpoint authenticate() {
        BackchannelAuthenticationCallbackEndpoint endpoint = new BackchannelAuthenticationCallbackEndpoint(this.session, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    public OIDCExtProvider create(KeycloakSession session) {
        return new CibaRootEndpoint(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    @Override
    public void close() {
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CIBA);
    }
}

