/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PolicyError;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.validation.Validation;

public class RegistrationPassword
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-password-action";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "Validates that password matches password confirmation field.  It also will store password in user's credential store.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void validate(ValidationContext context) {
        PolicyError err;
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        context.getEvent().detail("register_method", "form");
        if (Validation.isBlank((String)formData.getFirst((Object)"password"))) {
            errors.add(new FormMessage("password", "missingPasswordMessage"));
        } else if (!((String)formData.getFirst((Object)"password")).equals(formData.getFirst((Object)"password-confirm"))) {
            errors.add(new FormMessage("password-confirm", "invalidPasswordConfirmMessage"));
        }
        if (formData.getFirst((Object)"password") != null && (err = ((PasswordPolicyManagerProvider)context.getSession().getProvider(PasswordPolicyManagerProvider.class)).validate(context.getRealm().isRegistrationEmailAsUsername() ? (String)formData.getFirst((Object)"email") : (String)formData.getFirst((Object)"username"), (String)formData.getFirst((Object)"password"))) != null) {
            errors.add(new FormMessage("password", err.getMessage(), err.getParameters()));
        }
        if (errors.size() > 0) {
            context.error("invalid_registration");
            formData.remove((Object)"password");
            formData.remove((Object)"password-confirm");
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    public void success(FormContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String password = (String)formData.getFirst((Object)"password");
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("password");
        credentials.setValue(password);
        UserModel user = context.getUser();
        try {
            context.getSession().users().updateCredential(context.getRealm(), user, UserCredentialModel.password((String)((String)formData.getFirst((Object)"password"))));
        }
        catch (Exception me) {
            user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        form.setAttribute("passwordRequired", (Object)true);
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Password Validation";
    }

    public String getReferenceCategory() {
        return "password";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

