/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.validation.Validation;

public class UpdateTotp
implements RequiredActionProvider,
RequiredActionFactory {
    protected static ServicesLogger logger = ServicesLogger.ROOT_LOGGER;

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_TOTP);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        if (Validation.isBlank(totp)) {
            Response challenge = context.form().setError("missingTotpMessage", new Object[0]).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
            context.challenge(challenge);
            return;
        }
        if (!CredentialValidation.validOTP((RealmModel)context.getRealm(), (String)totp, (String)totpSecret)) {
            Response challenge = context.form().setError("invalidTotpMessage", new Object[0]).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
            context.challenge(challenge);
            return;
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType(context.getRealm().getOTPPolicy().getType());
        credentials.setValue(totpSecret);
        context.getSession().users().updateCredential(context.getRealm(), context.getUser(), credentials);
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType(context.getRealm().getOTPPolicy().getType());
        cred.setValue(totp);
        context.getSession().users().validCredentials(context.getSession(), context.getRealm(), context.getUser(), new UserCredentialModel[]{cred});
        context.getUser().setOtpEnabled(true);
        context.success();
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Configure OTP";
    }

    public String getId() {
        return UserModel.RequiredAction.CONFIGURE_TOTP.name();
    }
}

