/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.util;

import java.security.PublicKey;
import javax.ws.rs.core.Response;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public class Tokens {
    public static AccessToken getAccessToken(KeycloakSession keycloakSession) {
        AppAuthManager authManager = new AppAuthManager();
        KeycloakContext context = keycloakSession.getContext();
        AuthenticationManager.AuthResult authResult = authManager.authenticateBearerToken(keycloakSession, context.getRealm(), context.getUri(), context.getConnection(), context.getRequestHeaders());
        if (authResult != null) {
            return authResult.getToken();
        }
        return null;
    }

    public static String getAccessTokenAsString(KeycloakSession keycloakSession) {
        AppAuthManager authManager = new AppAuthManager();
        return authManager.extractAuthorizationHeaderToken(keycloakSession.getContext().getRequestHeaders());
    }

    public static boolean verifySignature(String token, PublicKey publicKey) {
        try {
            JWSInput jws = new JWSInput(token);
            return RSAProvider.verify((JWSInput)jws, (PublicKey)publicKey);
        }
        catch (Exception e) {
            throw new ErrorResponseException("invalid_signature", "Unexpected error while validating signature.", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

