/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.introspect;

import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.util.JsonSerialization;

public class RPTIntrospectionProvider
extends AccessTokenIntrospectionProvider {
    protected static final Logger LOGGER = Logger.getLogger(RPTIntrospectionProvider.class);

    public RPTIntrospectionProvider(KeycloakSession session) {
        super(session);
    }

    @Override
    public Response introspect(String token) {
        LOGGER.debug((Object)"Introspecting requesting party token");
        try {
            ObjectNode tokenMetadata;
            AccessToken requestingPartyToken = this.toAccessToken(token);
            boolean active = this.isActive(requestingPartyToken);
            if (active) {
                LOGGER.debug((Object)"Token is active");
                AccessToken introspect = new AccessToken();
                introspect.type(requestingPartyToken.getType());
                introspect.expiration(requestingPartyToken.getExpiration());
                introspect.issuedAt(requestingPartyToken.getIssuedAt());
                introspect.audience(requestingPartyToken.getAudience());
                introspect.notBefore(requestingPartyToken.getNotBefore());
                introspect.setRealmAccess(null);
                introspect.setResourceAccess(null);
                tokenMetadata = JsonSerialization.createObjectNode((Object)introspect);
                tokenMetadata.putPOJO("permissions", (Object)requestingPartyToken.getAuthorization().getPermissions());
            } else {
                LOGGER.debug((Object)"Token is not active");
                tokenMetadata = JsonSerialization.createObjectNode();
            }
            tokenMetadata.put("active", active);
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating token introspection response.", e);
        }
    }

    private boolean isActive(AccessToken requestingPartyToken) {
        AccessToken.Authorization authorization = requestingPartyToken.getAuthorization();
        return requestingPartyToken.isActive() && authorization != null && authorization.getPermissions() != null && !authorization.getPermissions().isEmpty();
    }

    @Override
    public void close() {
    }
}

