/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;

@Path(value="/resources")
public class ThemeResource {
    protected static final Logger logger = Logger.getLogger(ThemeResource.class);
    @Context
    private KeycloakSession session;

    @GET
    @Path(value="/{version}/{themeType}/{themeName}/{path:.*}")
    public Response getResource(@PathParam(value="version") String version, @PathParam(value="themeType") String themType, @PathParam(value="themeName") String themeName, @PathParam(value="path") String path) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
            Theme theme = themeProvider.getTheme(themeName, Theme.Type.valueOf((String)themType.toUpperCase()));
            InputStream resource = theme.getResourceAsStream(path);
            if (resource != null) {
                return Response.ok((Object)resource).type(MimeTypeUtil.getContentType((String)path)).cacheControl(CacheControlUtil.getDefaultCacheControl()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToGetThemeRequest(e);
            return Response.serverError().build();
        }
    }
}

