/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.github;

import com.fasterxml.jackson.databind.JsonNode;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.oidc.util.JsonSimpleHttp;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.models.KeycloakSession;

public class GitHubIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://github.com/login/oauth/authorize";
    public static final String TOKEN_URL = "https://github.com/login/oauth/access_token";
    public static final String PROFILE_URL = "https://api.github.com/user";
    public static final String DEFAULT_SCOPE = "user:email";

    public GitHubIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = JsonSimpleHttp.asJson(SimpleHttp.doGet((String)PROFILE_URL).header("Authorization", "Bearer " + accessToken));
            BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "id"));
            String username = this.getJsonProperty(profile, "login");
            user.setUsername(username);
            user.setName(this.getJsonProperty(profile, "name"));
            user.setEmail(this.getJsonProperty(profile, "email"));
            user.setIdpConfig(this.getConfig());
            user.setIdp((IdentityProvider)this);
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from github.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

