/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.BruteForceProtector;

public class DefaultBruteForceProtector
implements Runnable,
BruteForceProtector {
    private static final Logger logger = Logger.getLogger(DefaultBruteForceProtector.class);
    protected volatile boolean run = true;
    protected int maxDeltaTimeSeconds = 43200;
    protected KeycloakSessionFactory factory;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected volatile long failures;
    protected volatile long lastFailure;
    protected volatile long totalTime;
    protected LinkedBlockingQueue<LoginEvent> queue = new LinkedBlockingQueue();
    public static final int TRANSACTION_SIZE = 20;

    public DefaultBruteForceProtector(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    protected void failure(KeycloakSession session, LoginEvent event) {
        logger.debug((Object)"failure");
        RealmModel realm = this.getRealmModel(session, event);
        this.logFailure(event);
        String userId = event.userId;
        UserLoginFailureModel userLoginFailure = this.getUserModel(session, event);
        if (userLoginFailure == null) {
            userLoginFailure = session.loginFailures().addUserLoginFailure(realm, userId);
        }
        userLoginFailure.setLastIPFailure(event.ip);
        long currentTime = Time.currentTimeMillis();
        long last = userLoginFailure.getLastFailure();
        long deltaTime = 0L;
        if (last > 0L) {
            deltaTime = currentTime - last;
        }
        userLoginFailure.setLastFailure(currentTime);
        if (realm.isPermanentLockout()) {
            userLoginFailure.incrementFailures();
            logger.debugv("new num failures: {0}", (Object)userLoginFailure.getNumFailures());
            if (userLoginFailure.getNumFailures() == realm.getFailureFactor()) {
                UserModel user = session.users().getUserById(realm, userId);
                if (user == null) {
                    return;
                }
                logger.debugv("user {0} locked permanently due to too many login attempts", (Object)user.getUsername());
                user.setEnabled(false);
                user.setSingleAttribute("disabledReason", "permanentLockout");
                return;
            }
            if (last > 0L && deltaTime < realm.getQuickLoginCheckMilliSeconds()) {
                logger.debugv("quick login, set min wait seconds", new Object[0]);
                int waitSeconds = realm.getMinimumQuickLoginWaitSeconds();
                int notBefore = (int)(currentTime / 1000L) + waitSeconds;
                logger.debugv("set notBefore: {0}", (Object)notBefore);
                userLoginFailure.setFailedLoginNotBefore(notBefore);
            }
            return;
        }
        if (deltaTime > 0L && deltaTime > (long)realm.getMaxDeltaTimeSeconds() * 1000L) {
            userLoginFailure.clearFailures();
        }
        userLoginFailure.incrementFailures();
        logger.debugv("new num failures: {0}", (Object)userLoginFailure.getNumFailures());
        int waitSeconds = realm.getWaitIncrementSeconds() * (userLoginFailure.getNumFailures() / realm.getFailureFactor());
        logger.debugv("waitSeconds: {0}", (Object)waitSeconds);
        logger.debugv("deltaTime: {0}", (Object)deltaTime);
        if (waitSeconds == 0 && last > 0L && deltaTime < realm.getQuickLoginCheckMilliSeconds()) {
            logger.debugv("quick login, set min wait seconds", new Object[0]);
            waitSeconds = realm.getMinimumQuickLoginWaitSeconds();
        }
        if (waitSeconds > 0) {
            waitSeconds = Math.min(realm.getMaxFailureWaitSeconds(), waitSeconds);
            int notBefore = (int)(currentTime / 1000L) + waitSeconds;
            logger.debugv("set notBefore: {0}", (Object)notBefore);
            userLoginFailure.setFailedLoginNotBefore(notBefore);
        }
    }

    protected UserLoginFailureModel getUserModel(KeycloakSession session, LoginEvent event) {
        RealmModel realm = this.getRealmModel(session, event);
        if (realm == null) {
            return null;
        }
        UserLoginFailureModel user = session.loginFailures().getUserLoginFailure(realm, event.userId);
        if (user == null) {
            return null;
        }
        return user;
    }

    protected RealmModel getRealmModel(KeycloakSession session, LoginEvent event) {
        RealmModel realm = session.realms().getRealm(event.realmId);
        if (realm == null) {
            return null;
        }
        return realm;
    }

    public void start() {
        new Thread((Runnable)this, "Brute Force Protector").start();
    }

    public void shutdown() {
        this.run = false;
        try {
            this.queue.offer(new ShutdownEvent());
            this.shutdownLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block20: {
            events = new ArrayList<LoginEvent>(21);
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.run == false) return;
                try {
                    take = this.queue.poll(2L, TimeUnit.SECONDS);
                    if (take == null) ** GOTO lbl-1000
                    try {
                        events.add(take);
                        this.queue.drainTo(events, 20);
                        Collections.sort(events);
                        session = this.factory.create();
                        session.getTransactionManager().begin();
                        try {
                            for (LoginEvent event : events) {
                                if (event instanceof FailedLogin) {
                                    this.failure(session, event);
                                    continue;
                                }
                                if (event instanceof SuccessfulLogin) {
                                    this.success(session, event);
                                    continue;
                                }
                                if (!(event instanceof ShutdownEvent)) continue;
                                this.run = false;
                            }
                            session.getTransactionManager().commit();
                            var4_6 = events.iterator();
                            break block20;
                        }
                        catch (Exception e) {
                            try {
                                session.getTransactionManager().rollback();
                                throw e;
                            }
                            catch (Throwable var6_9) {
                                var7_10 = events.iterator();
                                while (true) {
                                    if (!var7_10.hasNext()) {
                                        events.clear();
                                        session.close();
                                        throw var6_9;
                                    }
                                    event = (LoginEvent)var7_10.next();
                                    if (event instanceof FailedLogin) {
                                        ((FailedLogin)event).latch.countDown();
                                        continue;
                                    }
                                    if (!(event instanceof SuccessfulLogin)) continue;
                                    ((SuccessfulLogin)event).latch.countDown();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        ServicesLogger.LOGGER.failedProcessingType(e);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                    return;
                }
                break;
            }
            finally {
                this.shutdownLatch.countDown();
            }
        }
        while (var4_6.hasNext()) {
            event = (LoginEvent)var4_6.next();
            if (event instanceof FailedLogin) {
                ((FailedLogin)event).latch.countDown();
                continue;
            }
            if (!(event instanceof SuccessfulLogin)) continue;
            ((SuccessfulLogin)event).latch.countDown();
        }
        events.clear();
        session.close();
        ** continue;
    }

    protected void success(KeycloakSession session, LoginEvent event) {
        String userId = event.userId;
        UserLoginFailureModel user = this.getUserModel(session, event);
        if (user == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            UserModel model = session.users().getUserById(this.getRealmModel(session, event), userId);
            logger.debugv("user {0} successfully logged in, clearing all failures", (Object)model.getUsername());
        }
        user.clearFailures();
    }

    protected void logFailure(LoginEvent event) {
        ServicesLogger.LOGGER.loginFailure(event.userId, event.ip);
        ++this.failures;
        long delta = 0L;
        if (this.lastFailure > 0L) {
            delta = Time.currentTimeMillis() - this.lastFailure;
            this.totalTime = delta > (long)this.maxDeltaTimeSeconds * 1000L ? 0L : (this.totalTime += delta);
        }
    }

    public void failedLogin(RealmModel realm, UserModel user, ClientConnection clientConnection) {
        try {
            FailedLogin event = new FailedLogin(realm.getId(), user.getId(), clientConnection.getRemoteAddr());
            this.queue.offer(event);
            event.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.trace((Object)"sent failure event");
    }

    public void successfulLogin(RealmModel realm, UserModel user, ClientConnection clientConnection) {
        SuccessfulLogin event = new SuccessfulLogin(realm.getId(), user.getId(), clientConnection.getRemoteAddr());
        this.queue.offer(event);
        logger.trace((Object)"sent success event");
    }

    public boolean isTemporarilyDisabled(KeycloakSession session, RealmModel realm, UserModel user) {
        int failedLoginNotBefore;
        int currTime;
        UserLoginFailureModel failure = session.loginFailures().getUserLoginFailure(realm, user.getId());
        if (failure != null && (currTime = (int)(Time.currentTimeMillis() / 1000L)) < (failedLoginNotBefore = failure.getFailedLoginNotBefore())) {
            logger.debugv("Current: {0} notBefore: {1}", (Object)currTime, (Object)failedLoginNotBefore);
            return true;
        }
        return false;
    }

    public boolean isPermanentlyLockedOut(KeycloakSession session, RealmModel realm, UserModel user) {
        return !user.isEnabled() && "permanentLockout".equals(user.getFirstAttribute("disabledReason"));
    }

    public void cleanUpPermanentLockout(KeycloakSession session, RealmModel realm, UserModel user) {
        if ("permanentLockout".equals(user.getFirstAttribute("disabledReason"))) {
            user.removeAttribute("disabledReason");
        }
    }

    public void close() {
    }

    protected class SuccessfulLogin
    extends LoginEvent {
        protected final CountDownLatch latch;

        public SuccessfulLogin(String realmId, String userId, String ip) {
            super(realmId, userId, ip);
            this.latch = new CountDownLatch(1);
        }
    }

    protected class FailedLogin
    extends LoginEvent {
        protected final CountDownLatch latch;

        public FailedLogin(String realmId, String userId, String ip) {
            super(realmId, userId, ip);
            this.latch = new CountDownLatch(1);
        }
    }

    protected class ShutdownEvent
    extends LoginEvent {
        public ShutdownEvent() {
            super(null, null, null);
        }
    }

    protected abstract class LoginEvent
    implements Comparable<LoginEvent> {
        protected final String realmId;
        protected final String userId;
        protected final String ip;

        protected LoginEvent(String realmId, String userId, String ip) {
            this.realmId = realmId;
            this.userId = userId;
            this.ip = ip;
        }

        @Override
        public int compareTo(LoginEvent o) {
            return this.userId.compareTo(o.userId);
        }
    }
}

