/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;

public class AuthenticationStateCookie {
    private static final Logger logger = Logger.getLogger(AuthenticationStateCookie.class);
    public static final String KC_AUTH_STATE = "KC_AUTH_STATE";
    @JsonProperty(value="authSessionId")
    private String authSessionId;
    @JsonProperty(value="remainingTabs")
    private Set<String> remainingTabs;

    public String getAuthSessionId() {
        return this.authSessionId;
    }

    public void setAuthSessionId(String authSessionId) {
        this.authSessionId = authSessionId;
    }

    public Set<String> getRemainingTabs() {
        return this.remainingTabs;
    }

    public void setRemainingTabs(Set<String> remainingTabs) {
        this.remainingTabs = remainingTabs;
    }

    public static void generateAndSetCookie(KeycloakSession session, RealmModel realm, RootAuthenticationSessionModel rootAuthSession, int cookieMaxAge) {
        UriInfo uriInfo = session.getContext().getHttpRequest().getUri();
        String path = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(session.getContext().getConnection());
        AuthenticationStateCookie cookie = new AuthenticationStateCookie();
        cookie.setAuthSessionId(rootAuthSession.getId());
        cookie.setRemainingTabs(rootAuthSession.getAuthenticationSessions().keySet());
        try {
            String encoded = JsonSerialization.writeValueAsString((Object)cookie);
            logger.tracef("Generating new %s cookie. Cookie: %s, Cookie lifespan: %d", (Object)KC_AUTH_STATE, (Object)encoded, (Object)cookieMaxAge);
            CookieHelper.addCookie(KC_AUTH_STATE, encoded, path, null, null, cookieMaxAge, secureOnly, false, session);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception thrown when encoding cookie", ioe);
        }
    }

    public static void expireCookie(RealmModel realm, KeycloakSession session) {
        UriInfo uriInfo = session.getContext().getHttpRequest().getUri();
        String path = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(session.getContext().getConnection());
        CookieHelper.addCookie(KC_AUTH_STATE, "", path, null, null, 0, secureOnly, false, session);
    }

    public String toString() {
        return "AuthenticationStateCookie [ " + ("authSessionId=" + this.authSessionId) + (", remainingTabs=" + this.remainingTabs) + " ]";
    }
}

