/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.Version;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.encoding.ResourceEncodingHelper;
import org.keycloak.encoding.ResourceEncodingProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.KeySource;
import org.keycloak.services.resources.Source;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.theme.Theme;

@Path(value="/resources")
public class ThemeResource {
    @Context
    private KeycloakSession session;

    @GET
    @Path(value="/{version}/{themeType}/{themeName}/{path:.*}")
    public Response getResource(@PathParam(value="version") String version, @PathParam(value="themeType") String themType, @PathParam(value="themeName") String themeName, @PathParam(value="path") String path) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            String contentType = MimeTypeUtil.getContentType((String)path);
            Theme theme = this.session.theme().getTheme(themeName, Theme.Type.valueOf((String)themType.toUpperCase()));
            ResourceEncodingProvider encodingProvider = this.session.theme().isCacheEnabled() ? ResourceEncodingHelper.getResourceEncodingProvider(this.session, contentType) : null;
            InputStream resource = encodingProvider != null ? encodingProvider.getEncodedStream(() -> theme.getResourceAsStream(path), themType, themeName, path.replace('/', File.separatorChar)) : theme.getResourceAsStream(path);
            if (resource != null) {
                Response.ResponseBuilder rb = Response.ok((Object)resource).type(contentType).cacheControl(CacheControlUtil.getDefaultCacheControl());
                if (encodingProvider != null) {
                    rb.encoding(encodingProvider.getEncoding());
                }
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToGetThemeRequest(e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/{realm}/{themeType}/{locale}")
    @Produces(value={"application/json"})
    public Response getLocalizationTexts(@PathParam(value="realm") String realmName, @QueryParam(value="theme") String theme, @PathParam(value="locale") String localeString, @PathParam(value="themeType") String themeType, @QueryParam(value="source") boolean showSource) throws IOException {
        List result;
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        this.session.getContext().setRealm(realm);
        Theme.Type type = Theme.Type.valueOf((String)themeType.toUpperCase());
        Theme theTheme = theme == null ? this.session.theme().getTheme(type) : this.session.theme().getTheme(theme, type);
        Locale locale = Locale.forLanguageTag(localeString);
        if (showSource) {
            Properties messagesByLocale = theTheme.getMessages("messages", locale);
            Set resultSet = messagesByLocale.entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue(), Source.THEME)).collect(Collectors.toSet());
            Map<Locale, Properties> realmLocalizationMessages = LocaleUtil.getRealmLocalizationTexts(realm, locale);
            Locale currentLocale = locale;
            while (currentLocale != null) {
                List realmOverride = realmLocalizationMessages.get(currentLocale).entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue(), Source.REALM)).collect(Collectors.toList());
                resultSet.addAll(realmOverride);
                currentLocale = LocaleUtil.getParentLocale(currentLocale);
            }
            result = new ArrayList(resultSet);
        } else {
            result = theTheme.getEnhancedMessages(realm, locale).entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
        Response.ResponseBuilder responseBuilder = Response.ok(result);
        return Cors.add(this.session.getContext().getHttpRequest(), responseBuilder).allowedOrigins("*").auth().build();
    }
}

