/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.oidc.AbstractClientConfigWrapper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.utils.StringUtil;

public class OIDCAdvancedConfigWrapper
extends AbstractClientConfigWrapper {
    private OIDCAdvancedConfigWrapper(ClientModel client, ClientRepresentation clientRep) {
        super(client, clientRep);
    }

    public static OIDCAdvancedConfigWrapper fromClientModel(ClientModel client) {
        return new OIDCAdvancedConfigWrapper(client, null);
    }

    public static OIDCAdvancedConfigWrapper fromClientRepresentation(ClientRepresentation clientRep) {
        return new OIDCAdvancedConfigWrapper(null, clientRep);
    }

    public String getUserInfoSignedResponseAlg() {
        return this.getAttribute("user.info.response.signature.alg");
    }

    public void setUserInfoSignedResponseAlg(String algorithm) {
        this.setAttribute("user.info.response.signature.alg", algorithm);
    }

    public boolean isUserInfoSignatureRequired() {
        return this.getUserInfoSignedResponseAlg() != null;
    }

    public void setUserInfoEncryptedResponseAlg(String algorithm) {
        this.setAttribute("user.info.encrypted.response.alg", algorithm);
    }

    public String getUserInfoEncryptedResponseAlg() {
        return this.getAttribute("user.info.encrypted.response.alg");
    }

    public String getUserInfoEncryptedResponseEnc() {
        return this.getAttribute("user.info.encrypted.response.enc");
    }

    public void setUserInfoEncryptedResponseEnc(String algorithm) {
        this.setAttribute("user.info.encrypted.response.enc", algorithm);
    }

    public boolean isUserInfoEncryptionRequired() {
        return this.getUserInfoEncryptedResponseAlg() != null;
    }

    public String getRequestObjectSignatureAlg() {
        return this.getAttribute("request.object.signature.alg");
    }

    public void setRequestObjectSignatureAlg(String algorithm) {
        this.setAttribute("request.object.signature.alg", algorithm);
    }

    public void setRequestObjectEncryptionAlg(String algorithm) {
        this.setAttribute("request.object.encryption.alg", algorithm);
    }

    public String getRequestObjectEncryptionAlg() {
        return this.getAttribute("request.object.encryption.alg");
    }

    public String getRequestObjectEncryptionEnc() {
        return this.getAttribute("request.object.encryption.enc");
    }

    public void setRequestObjectEncryptionEnc(String algorithm) {
        this.setAttribute("request.object.encryption.enc", algorithm);
    }

    public String getRequestObjectRequired() {
        return this.getAttribute("request.object.required");
    }

    public void setRequestObjectRequired(String requestObjectRequired) {
        this.setAttribute("request.object.required", requestObjectRequired);
    }

    public List<String> getRequestUris() {
        return this.getAttributeMultivalued("request.uris");
    }

    public void setRequestUris(List<String> requestUris) {
        this.setAttributeMultivalued("request.uris", requestUris);
    }

    public boolean isUseJwksUrl() {
        String useJwksUrl = this.getAttribute("use.jwks.url");
        return Boolean.parseBoolean(useJwksUrl);
    }

    public void setUseJwksUrl(boolean useJwksUrl) {
        String val = String.valueOf(useJwksUrl);
        this.setAttribute("use.jwks.url", val);
    }

    public String getJwksUrl() {
        return this.getAttribute("jwks.url");
    }

    public void setJwksUrl(String jwksUrl) {
        this.setAttribute("jwks.url", jwksUrl);
    }

    public boolean isUseJwksString() {
        String useJwksString = this.getAttribute("use.jwks.string");
        return Boolean.parseBoolean(useJwksString);
    }

    public void setUseJwksString(boolean useJwksString) {
        String val = String.valueOf(useJwksString);
        this.setAttribute("use.jwks.string", val);
    }

    public String getJwksString() {
        return this.getAttribute("jwks.string");
    }

    public void setJwksString(String jwksString) {
        this.setAttribute("jwks.string", jwksString);
    }

    public boolean isExcludeSessionStateFromAuthResponse() {
        String excludeSessionStateFromAuthResponse = this.getAttribute("exclude.session.state.from.auth.response");
        return Boolean.parseBoolean(excludeSessionStateFromAuthResponse);
    }

    public void setExcludeSessionStateFromAuthResponse(boolean excludeSessionStateFromAuthResponse) {
        String val = String.valueOf(excludeSessionStateFromAuthResponse);
        this.setAttribute("exclude.session.state.from.auth.response", val);
    }

    public boolean isExcludeIssuerFromAuthResponse() {
        String excludeIssuerFromAuthResponse = this.getAttribute("exclude.issuer.from.auth.response");
        return Boolean.parseBoolean(excludeIssuerFromAuthResponse);
    }

    public void setExcludeIssuerFromAuthResponse(boolean excludeIssuerFromAuthResponse) {
        String val = String.valueOf(excludeIssuerFromAuthResponse);
        this.setAttribute("exclude.issuer.from.auth.response", val);
    }

    public boolean isUseDPoP() {
        String mode = this.getAttribute("dpop.bound.access.tokens");
        return Boolean.parseBoolean(mode);
    }

    public void setUseDPoP(boolean useDPoP) {
        String val = String.valueOf(useDPoP);
        this.setAttribute("dpop.bound.access.tokens", val);
    }

    public boolean isUseMtlsHokToken() {
        String useUtlsHokToken = this.getAttribute("tls.client.certificate.bound.access.tokens");
        return Boolean.parseBoolean(useUtlsHokToken);
    }

    public void setUseMtlsHoKToken(boolean useUtlsHokToken) {
        String val = String.valueOf(useUtlsHokToken);
        this.setAttribute("tls.client.certificate.bound.access.tokens", val);
    }

    public boolean isUseRefreshToken() {
        String useRefreshToken = this.getAttribute("use.refresh.tokens", "true");
        return Boolean.parseBoolean(useRefreshToken);
    }

    public void setUseRefreshToken(boolean useRefreshToken) {
        String val = String.valueOf(useRefreshToken);
        this.setAttribute("use.refresh.tokens", val);
    }

    public boolean isUseLowerCaseInTokenResponse() {
        return Boolean.parseBoolean(this.getAttribute("token.response.type.bearer.lower-case", "false"));
    }

    public void setUseLowerCaseInTokenResponse(boolean useRefreshToken) {
        this.setAttribute("token.response.type.bearer.lower-case", String.valueOf(useRefreshToken));
    }

    public boolean isUseRefreshTokenForClientCredentialsGrant() {
        String val = this.getAttribute("client_credentials.use_refresh_token", "false");
        return Boolean.parseBoolean(val);
    }

    public void setUseRefreshTokenForClientCredentialsGrant(boolean enable) {
        String val = String.valueOf(enable);
        this.setAttribute("client_credentials.use_refresh_token", val);
    }

    public String getTlsClientAuthSubjectDn() {
        return this.getAttribute("x509.subjectdn");
    }

    public void setTlsClientAuthSubjectDn(String tls_client_auth_subject_dn) {
        this.setAttribute("x509.subjectdn", tls_client_auth_subject_dn);
    }

    public boolean getAllowRegexPatternComparison() {
        String attrVal = this.getAttribute("x509.allow.regex.pattern.comparison");
        return attrVal == null || Boolean.parseBoolean(attrVal);
    }

    public void setAllowRegexPatternComparison(boolean allowRegexPatternComparison) {
        this.setAttribute("x509.allow.regex.pattern.comparison", String.valueOf(allowRegexPatternComparison));
    }

    public String getPkceCodeChallengeMethod() {
        return this.getAttribute("pkce.code.challenge.method");
    }

    public void setPkceCodeChallengeMethod(String codeChallengeMethodName) {
        this.setAttribute("pkce.code.challenge.method", codeChallengeMethodName);
    }

    public String getIdTokenSignedResponseAlg() {
        return this.getAttribute("id.token.signed.response.alg");
    }

    public void setIdTokenSignedResponseAlg(String algName) {
        this.setAttribute("id.token.signed.response.alg", algName);
    }

    public String getIdTokenEncryptedResponseAlg() {
        return this.getAttribute("id.token.encrypted.response.alg");
    }

    public void setIdTokenEncryptedResponseAlg(String algName) {
        this.setAttribute("id.token.encrypted.response.alg", algName);
    }

    public String getIdTokenEncryptedResponseEnc() {
        return this.getAttribute("id.token.encrypted.response.enc");
    }

    public void setIdTokenEncryptedResponseEnc(String encName) {
        this.setAttribute("id.token.encrypted.response.enc", encName);
    }

    public String getAuthorizationSignedResponseAlg() {
        return this.getAttribute("authorization.signed.response.alg");
    }

    public void setAuthorizationSignedResponseAlg(String algName) {
        this.setAttribute("authorization.signed.response.alg", algName);
    }

    public String getAuthorizationEncryptedResponseAlg() {
        return this.getAttribute("authorization.encrypted.response.alg");
    }

    public void setAuthorizationEncryptedResponseAlg(String algName) {
        this.setAttribute("authorization.encrypted.response.alg", algName);
    }

    public String getAuthorizationEncryptedResponseEnc() {
        return this.getAttribute("authorization.encrypted.response.enc");
    }

    public void setAuthorizationEncryptedResponseEnc(String encName) {
        this.setAttribute("authorization.encrypted.response.enc", encName);
    }

    public String getTokenEndpointAuthSigningAlg() {
        return this.getAttribute("token.endpoint.auth.signing.alg");
    }

    public void setTokenEndpointAuthSigningAlg(String algName) {
        this.setAttribute("token.endpoint.auth.signing.alg", algName);
    }

    public String getBackchannelLogoutUrl() {
        return this.getAttribute("backchannel.logout.url");
    }

    public void setBackchannelLogoutUrl(String backchannelLogoutUrl) {
        this.setAttribute("backchannel.logout.url", backchannelLogoutUrl);
    }

    public boolean isBackchannelLogoutSessionRequired() {
        String backchannelLogoutSessionRequired = this.getAttribute("backchannel.logout.session.required");
        return Boolean.parseBoolean(backchannelLogoutSessionRequired);
    }

    public void setBackchannelLogoutSessionRequired(boolean backchannelLogoutSessionRequired) {
        String val = String.valueOf(backchannelLogoutSessionRequired);
        this.setAttribute("backchannel.logout.session.required", val);
    }

    public boolean getBackchannelLogoutRevokeOfflineTokens() {
        String backchannelLogoutRevokeOfflineTokens = this.getAttribute("backchannel.logout.revoke.offline.tokens");
        return Boolean.parseBoolean(backchannelLogoutRevokeOfflineTokens);
    }

    public void setBackchannelLogoutRevokeOfflineTokens(boolean backchannelLogoutRevokeOfflineTokens) {
        String val = String.valueOf(backchannelLogoutRevokeOfflineTokens);
        this.setAttribute("backchannel.logout.revoke.offline.tokens", val);
    }

    public void setFrontChannelLogoutUrl(String frontChannelLogoutUrl) {
        if (this.clientRep != null) {
            this.clientRep.setFrontchannelLogout(Boolean.valueOf(StringUtil.isNotBlank((String)frontChannelLogoutUrl)));
        }
        if (this.clientModel != null) {
            this.clientModel.setFrontchannelLogout(StringUtil.isNotBlank((String)frontChannelLogoutUrl));
        }
        this.setAttribute("frontchannel.logout.url", frontChannelLogoutUrl);
    }

    public boolean isFrontChannelLogoutEnabled() {
        return this.clientModel != null && this.clientModel.isFrontchannelLogout() && StringUtil.isNotBlank((String)this.getFrontChannelLogoutUrl());
    }

    public String getFrontChannelLogoutUrl() {
        return this.getAttribute("frontchannel.logout.url");
    }

    public boolean isFrontChannelLogoutSessionRequired() {
        String frontChannelLogoutSessionRequired = this.getAttribute("frontchannel.logout.session.required");
        return frontChannelLogoutSessionRequired == null ? true : Boolean.parseBoolean(frontChannelLogoutSessionRequired);
    }

    public void setFrontChannelLogoutSessionRequired(boolean frontChannelLogoutSessionRequired) {
        String val = String.valueOf(frontChannelLogoutSessionRequired);
        this.setAttribute("frontchannel.logout.session.required", val);
    }

    public void setLogoUri(String logoUri) {
        this.setAttribute("logoUri", logoUri);
    }

    public void setPolicyUri(String policyUri) {
        this.setAttribute("policyUri", policyUri);
    }

    public void setTosUri(String tosUri) {
        this.setAttribute("tosUri", tosUri);
    }

    public List<String> getPostLogoutRedirectUris() {
        List<String> postLogoutRedirectUris = this.getAttributeMultivalued("post.logout.redirect.uris");
        if (postLogoutRedirectUris == null || postLogoutRedirectUris.isEmpty()) {
            if (this.clientModel != null) {
                return new ArrayList<String>(this.clientModel.getRedirectUris());
            }
            if (this.clientRep != null) {
                return this.clientRep.getRedirectUris();
            }
            return null;
        }
        if (postLogoutRedirectUris.get(0).equals("-")) {
            return new ArrayList<String>();
        }
        if (postLogoutRedirectUris.contains("+")) {
            Set returnedPostLogoutRedirectUris = postLogoutRedirectUris.stream().filter(uri -> !"+".equals(uri)).collect(Collectors.toSet());
            if (this.clientModel != null) {
                returnedPostLogoutRedirectUris.addAll(this.clientModel.getRedirectUris());
            } else if (this.clientRep != null) {
                returnedPostLogoutRedirectUris.addAll(this.clientRep.getRedirectUris());
            }
            return new ArrayList<String>(returnedPostLogoutRedirectUris);
        }
        return postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.setAttributeMultivalued("post.logout.redirect.uris", postLogoutRedirectUris);
    }
}

