/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.enums.AccountRestApiVersion;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resource.AccountResourceProvider;
import org.keycloak.services.resources.account.AccountRestService;
import org.keycloak.services.resources.account.CorsPreflightService;
import org.keycloak.theme.Theme;

public class AccountLoader {
    private final KeycloakSession session;
    private final EventBuilder event;
    private final HttpRequest request;
    private final HttpResponse response;
    private static final Logger logger = Logger.getLogger(AccountLoader.class);

    public AccountLoader(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.event = event;
        this.request = session.getContext().getHttpRequest();
        this.response = session.getContext().getHttpResponse();
    }

    @Path(value="/")
    public Object getAccountService() {
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = this.getAccountManagementClient(realm);
        HttpRequest request = this.session.getContext().getHttpRequest();
        HttpHeaders headers = this.session.getContext().getRequestHeaders();
        MediaType content = headers.getMediaType();
        List accepts = headers.getAcceptableMediaTypes();
        Theme theme = this.getTheme(this.session);
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        AccountResourceProvider accountResourceProvider = this.getAccountResourceProvider(theme);
        if (request.getHttpMethod().equals("OPTIONS")) {
            return new CorsPreflightService(request);
        }
        if ((accepts.contains(MediaType.APPLICATION_JSON_TYPE) || MediaType.APPLICATION_JSON_TYPE.equals((Object)content)) && !uriInfo.getPath().endsWith("keycloak.json")) {
            return this.getAccountRestService(client, null);
        }
        if (accountResourceProvider != null) {
            return accountResourceProvider.getResource();
        }
        throw new NotFoundException();
    }

    @Path(value="{version : v\\d[0-9a-zA-Z_\\-]*}")
    @Produces(value={"application/json"})
    public Object getVersionedAccountRestService(@PathParam(value="version") String version) {
        if (this.request.getHttpMethod().equals("OPTIONS")) {
            return new CorsPreflightService(this.request);
        }
        return this.getAccountRestService(this.getAccountManagementClient(this.session.getContext().getRealm()), version);
    }

    private Theme getTheme(KeycloakSession session) {
        try {
            return session.theme().getTheme(Theme.Type.ACCOUNT);
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    private AccountRestService getAccountRestService(ClientModel client, String versionStr) {
        AccountRestApiVersion version;
        AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(this.session).authenticate();
        if (authResult == null) {
            throw new NotAuthorizedException((Object)"Bearer token required", new Object[0]);
        }
        AccessToken accessToken = authResult.getToken();
        if (accessToken.getAudience() == null || accessToken.getResourceAccess(client.getClientId()) == null) {
            AccessTokenIntrospectionProvider provider = (AccessTokenIntrospectionProvider)this.session.getProvider(TokenIntrospectionProvider.class, "access_token");
            accessToken = provider.transformAccessToken(accessToken);
        }
        if (!accessToken.hasAudience(client.getClientId())) {
            throw new NotAuthorizedException((Object)("Invalid audience for client " + client.getClientId()), new Object[0]);
        }
        Auth auth = new Auth(this.session.getContext().getRealm(), accessToken, authResult.getUser(), client, authResult.getSession(), false);
        Cors.add((HttpRequest)this.request).allowedOrigins(auth.getToken()).allowedMethods(new String[]{"GET", "PUT", "POST", "DELETE"}).auth().build(this.response);
        if (authResult.getUser().getServiceAccountClientLink() != null) {
            throw new NotAuthorizedException((Object)"Service accounts are not allowed to access this service", new Object[0]);
        }
        if (versionStr == null) {
            version = AccountRestApiVersion.DEFAULT;
        } else {
            version = AccountRestApiVersion.get((String)versionStr);
            if (version == null) {
                throw new NotFoundException("API version not found");
            }
        }
        return new AccountRestService(this.session, auth, this.event, version);
    }

    private ClientModel getAccountManagementClient(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("account");
        if (client == null || !client.isEnabled()) {
            logger.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        return client;
    }

    private AccountResourceProvider getAccountResourceProvider(Theme theme) {
        try {
            if (theme.getProperties().containsKey("accountResourceProvider")) {
                return (AccountResourceProvider)this.session.getProvider(AccountResourceProvider.class, theme.getProperties().getProperty("accountResourceProvider"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (AccountResourceProvider)this.session.getProvider(AccountResourceProvider.class);
    }
}

