/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.authorization.AuthorizationTokenService;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.managers.AppAuthManager;

public class PermissionGrantType
extends OAuth2GrantTypeBase {
    public Response process(OAuth2GrantType.Context context) {
        String responsePermissionsLimit;
        this.setContext(context);
        this.event.detail("auth_method", "oauth_credentials");
        String accessTokenString = null;
        String authorizationHeader = (String)this.headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authorizationHeader != null && authorizationHeader.toLowerCase().startsWith("bearer")) {
            new AppAuthManager();
            accessTokenString = AppAuthManager.extractAuthorizationHeaderToken(this.headers);
        }
        if (accessTokenString != null) {
            AccessToken accessToken = Tokens.getAccessToken(this.session);
            if (accessToken == null) {
                try {
                    AccessToken invalidToken = (AccessToken)new JWSInput(accessTokenString).readJsonContent(AccessToken.class);
                    ClientModel client = this.realm.getClientByClientId(invalidToken.getIssuedFor());
                    this.cors.allowedOrigins(this.session, client);
                    this.event.client(client);
                }
                catch (JWSInputException invalidToken) {
                    // empty catch block
                }
                this.event.error("invalid_token");
                throw new CorsErrorResponseException(this.cors, "invalid_grant", "Invalid bearer token", Response.Status.UNAUTHORIZED);
            }
            ClientModel client = this.realm.getClientByClientId(accessToken.getIssuedFor());
            this.session.getContext().setClient(client);
            this.cors.allowedOrigins(this.session, client);
            this.event.client(client);
        }
        String claimToken = null;
        if (this.formParams.containsKey((Object)"claim_token")) {
            claimToken = (String)((List)this.formParams.get((Object)"claim_token")).get(0);
        }
        String claimTokenFormat = (String)this.formParams.getFirst((Object)"claim_token_format");
        if (claimToken != null && claimTokenFormat == null) {
            claimTokenFormat = "http://openid.net/specs/openid-connect-core-1_0.html#IDToken";
        }
        String subjectToken = (String)this.formParams.getFirst((Object)"subject_token");
        if (accessTokenString == null) {
            this.checkClient();
            if ("http://openid.net/specs/openid-connect-core-1_0.html#IDToken".equalsIgnoreCase(claimTokenFormat)) {
                accessTokenString = claimToken;
            } else if (subjectToken != null) {
                accessTokenString = subjectToken;
            } else {
                OAuth2GrantType clientCredentialsGrant = (OAuth2GrantType)this.session.getProvider(OAuth2GrantType.class, "client_credentials");
                context.setClient(this.client);
                context.setClientConfig((Object)this.clientConfig);
                context.setClientAuthAttributes(this.clientAuthAttributes);
                accessTokenString = ((AccessTokenResponse)AccessTokenResponse.class.cast(clientCredentialsGrant.process(context).getEntity())).getToken();
            }
        }
        AuthorizationTokenService.KeycloakAuthorizationRequest authorizationRequest = new AuthorizationTokenService.KeycloakAuthorizationRequest((AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class), this.tokenManager, this.event, this.request, this.cors, this.clientConnection);
        authorizationRequest.setTicket((String)this.formParams.getFirst((Object)"ticket"));
        authorizationRequest.setClaimToken(claimToken);
        authorizationRequest.setClaimTokenFormat(claimTokenFormat);
        authorizationRequest.setPct((String)this.formParams.getFirst((Object)"pct"));
        String rpt = (String)this.formParams.getFirst((Object)"rpt");
        if (rpt != null) {
            AccessToken accessToken = (AccessToken)this.session.tokens().decode(rpt, AccessToken.class);
            if (accessToken == null) {
                String errorMessage = "RPT signature is invalid";
                this.event.detail("reason", errorMessage);
                this.event.error("invalid_request");
                throw new CorsErrorResponseException(this.cors, "invalid_rpt", errorMessage, Response.Status.FORBIDDEN);
            }
            authorizationRequest.setRpt(accessToken);
        }
        authorizationRequest.setScope((String)this.formParams.getFirst((Object)"scope"));
        String audienceParam = (String)this.formParams.getFirst((Object)"audience");
        authorizationRequest.setAudience(audienceParam);
        authorizationRequest.setSubjectToken(accessTokenString);
        this.event.detail("audience", audienceParam);
        String submitRequest = (String)this.formParams.getFirst((Object)"submit_request");
        authorizationRequest.setSubmitRequest(submitRequest == null ? true : Boolean.valueOf(submitRequest));
        List permissions = (List)this.formParams.get((Object)"permission");
        if (permissions != null) {
            this.event.detail("permission", String.join((CharSequence)"|", permissions));
            String permissionResourceFormat = (String)this.formParams.getFirst((Object)"permission_resource_format");
            boolean permissionResourceMatchingUri = Boolean.parseBoolean((String)this.formParams.getFirst((Object)"permission_resource_matching_uri"));
            authorizationRequest.addPermissions(permissions, permissionResourceFormat, permissionResourceMatchingUri);
        }
        AuthorizationRequest.Metadata metadata = new AuthorizationRequest.Metadata();
        String responseIncludeResourceName = (String)this.formParams.getFirst((Object)"response_include_resource_name");
        if (responseIncludeResourceName != null) {
            metadata.setIncludeResourceName(Boolean.valueOf(Boolean.parseBoolean(responseIncludeResourceName)));
        }
        if ((responsePermissionsLimit = (String)this.formParams.getFirst((Object)"response_permissions_limit")) != null) {
            metadata.setLimit(Integer.valueOf(Integer.parseInt(responsePermissionsLimit)));
        }
        metadata.setResponseMode((String)this.formParams.getFirst((Object)"response_mode"));
        authorizationRequest.setMetadata(metadata);
        Response authorizationResponse = AuthorizationTokenService.instance().authorize(authorizationRequest);
        this.event.success();
        return authorizationResponse;
    }

    public EventType getEventType() {
        return EventType.PERMISSION_TOKEN;
    }
}

