/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ErrorPage;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ErrorPageException
extends WebApplicationException {
    private final KeycloakSession session;
    private Response.Status status;
    private final String errorMessage;
    private final Object[] parameters;
    private final AuthenticationSessionModel authSession;

    public ErrorPageException(KeycloakSession session, Response.Status status, String errorMessage, Object ... parameters) {
        super(errorMessage, status);
        this.session = session;
        this.status = status;
        this.errorMessage = errorMessage;
        this.parameters = parameters;
        this.authSession = null;
    }

    public ErrorPageException(KeycloakSession session, AuthenticationSessionModel authSession, Response.Status status, String errorMessage, Object ... parameters) {
        this.session = session;
        this.status = status;
        this.errorMessage = errorMessage;
        this.parameters = parameters;
        this.authSession = authSession;
    }

    public Response getResponse() {
        return ErrorPage.error(this.session, this.authSession, this.status, this.errorMessage, this.parameters);
    }
}

