/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.admin.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.admin.resource.OrganizationIdentityProvidersResource;
import org.keycloak.organization.admin.resource.OrganizationMemberResource;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;

@Provider
@Extension(name="x-smallrye-profile-admin", value="")
public class OrganizationResource {
    private final KeycloakSession session;
    private final OrganizationProvider provider;
    private final AdminEventBuilder adminEvent;
    private final OrganizationModel organization;

    public OrganizationResource() {
        this(null, null, null);
    }

    public OrganizationResource(KeycloakSession session, OrganizationModel organization, AdminEventBuilder adminEvent) {
        this.session = session;
        this.provider = session == null ? null : (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        this.organization = organization;
        this.adminEvent = adminEvent;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Returns the organization representation")
    public OrganizationRepresentation get() {
        return Organizations.toRepresentation(this.organization);
    }

    @DELETE
    @Tag(name="Organizations")
    @Operation(summary="Deletes the organization")
    public Response delete() {
        this.provider.remove(this.organization);
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Updates the organization")
    public Response update(OrganizationRepresentation organizationRep) {
        try {
            Organizations.toModel(organizationRep, this.organization);
            return Response.noContent().build();
        }
        catch (ModelValidationException mve) {
            throw ErrorResponse.error(mve.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="members")
    public OrganizationMemberResource members() {
        return new OrganizationMemberResource(this.session, this.organization, this.adminEvent);
    }

    @Path(value="identity-providers")
    public OrganizationIdentityProvidersResource identityProvider() {
        return new OrganizationIdentityProvidersResource(this.session, this.organization, this.adminEvent);
    }
}

