/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import jakarta.ws.rs.core.HttpHeaders;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.keycloak.common.ClientConnection;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.urls.UrlType;

public abstract class DefaultKeycloakContext
implements KeycloakContext {
    private RealmModel realm;
    private ClientModel client;
    protected KeycloakSession session;
    private Map<UrlType, KeycloakUriInfo> uriInfo;
    private AuthenticationSessionModel authenticationSession;
    private HttpRequest request;
    private HttpResponse response;
    private ClientConnection clientConnection;

    public DefaultKeycloakContext(KeycloakSession session) {
        this.session = session;
    }

    public URI getAuthServerUrl() {
        return this.getUri(UrlType.FRONTEND).getBaseUri();
    }

    public String getContextPath() {
        return this.getUri(UrlType.FRONTEND).getBaseUri().getPath();
    }

    public KeycloakUriInfo getUri(UrlType type) {
        if (this.uriInfo == null || !this.uriInfo.containsKey(type)) {
            if (this.uriInfo == null) {
                this.uriInfo = new HashMap<UrlType, KeycloakUriInfo>();
            }
            this.uriInfo.put(type, new KeycloakUriInfo(this.session, type, this.getHttpRequest().getUri()));
        }
        return this.uriInfo.get(type);
    }

    public KeycloakUriInfo getUri() {
        return this.getUri(UrlType.FRONTEND);
    }

    @Deprecated
    public HttpHeaders getRequestHeaders() {
        return this.getHttpRequest().getHttpHeaders();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void setRealm(RealmModel realm) {
        this.realm = realm;
        this.uriInfo = null;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public ClientConnection getConnection() {
        if (this.clientConnection == null) {
            this.clientConnection = this.createClientConnection();
        }
        return this.clientConnection;
    }

    public Locale resolveLocale(UserModel user) {
        return ((LocaleSelectorProvider)this.session.getProvider(LocaleSelectorProvider.class)).resolveLocale(this.getRealm(), user);
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
    }

    public HttpRequest getHttpRequest() {
        if (this.request == null) {
            this.request = this.createHttpRequest();
        }
        return this.request;
    }

    public HttpResponse getHttpResponse() {
        if (this.response == null) {
            this.response = this.createHttpResponse();
        }
        return this.response;
    }

    protected ClientConnection createClientConnection() {
        return null;
    }

    protected abstract HttpRequest createHttpRequest();

    protected abstract HttpResponse createHttpResponse();

    protected KeycloakSession getSession() {
        return this.session;
    }

    public void setConnection(ClientConnection clientConnection) {
        this.clientConnection = clientConnection;
    }

    public void setHttpRequest(HttpRequest httpRequest) {
        this.request = httpRequest;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
    }
}

