/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.Base64Url;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.keys.AbstractHmacKeyProviderFactory;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.GeneratedHmacKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedHmacKeyProviderFactory
extends AbstractHmacKeyProviderFactory {
    private static final Logger logger = Logger.getLogger(GeneratedHmacKeyProviderFactory.class);
    public static final String ID = "hmac-generated";
    private static final String HELP_TEXT = "Generates HMAC secret key";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractHmacKeyProviderFactory.configurationBuilder().property(Attributes.SECRET_SIZE_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new GeneratedHmacKeyProvider(model);
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkList(Attributes.SECRET_SIZE_PROPERTY, false);
        int size = model.get("secretSize", 32);
        if (!model.contains("secret")) {
            this.generateSecret(model, size);
            logger.debugv("Generated secret for {0}", (Object)realm.getName());
        } else {
            int currentSize = Base64Url.decode((String)model.get("secret")).length;
            if (currentSize != size) {
                this.generateSecret(model, size);
                logger.debugv("Secret size changed, generating new secret for {0}", (Object)realm.getName());
            }
        }
    }

    private void generateSecret(ComponentModel model, int size) {
        try {
            String secret = KeycloakModelUtils.generateSecret((int)size);
            model.put("secret", secret);
            String kid = KeycloakModelUtils.generateId();
            model.put("kid", kid);
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to generate secret", t);
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

