/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;

public class ProtocolMappersClientRegistrationPolicy
implements ClientRegistrationPolicy {
    private static final Logger logger = Logger.getLogger(ProtocolMappersClientRegistrationPolicy.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ProtocolMappersClientRegistrationPolicy(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    @Override
    public void beforeRegister(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
        this.testMappers(context);
    }

    protected void testMappers(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
        List protocolMappers = context.getClient().getProtocolMappers();
        if (protocolMappers == null) {
            return;
        }
        List<String> allowedMapperProviders = this.getAllowedMapperProviders();
        for (ProtocolMapperRepresentation mapper : protocolMappers) {
            String mapperType = mapper.getProtocolMapper();
            if (allowedMapperProviders.contains(mapperType)) continue;
            ServicesLogger.LOGGER.clientRegistrationMapperNotAllowed(mapper.getName(), mapperType);
            throw new ClientRegistrationPolicyException("ProtocolMapper type not allowed");
        }
    }

    protected void enableConsentRequiredForAll(ClientModel clientModel) {
        if (this.isConsentRequiredForMappers()) {
            logger.debugf("Enable consentRequired for all protocol mappers of client %s", (Object)clientModel.getClientId());
            Set mappers = clientModel.getProtocolMappers();
            for (ProtocolMapperModel mapper : mappers) {
                mapper.setConsentRequired(true);
                if (mapper.getConsentText() == null) {
                    mapper.setConsentText(mapper.getName());
                }
                clientModel.updateProtocolMapper(mapper);
            }
        }
    }

    @Override
    public void afterRegister(ClientRegistrationContext context, ClientModel clientModel) {
        List<String> allowedMapperProviders = this.getAllowedMapperProviders();
        Set createdMappers = clientModel.getProtocolMappers();
        createdMappers.stream().filter(mapper -> !allowedMapperProviders.contains(mapper.getProtocolMapper())).forEach(mapperToRemove -> {
            logger.debugf("Removing builtin mapper '%s' of type '%s' as type is not permitted", (Object)mapperToRemove.getName(), (Object)mapperToRemove.getProtocolMapper());
            clientModel.removeProtocolMapper(mapperToRemove);
        });
        this.enableConsentRequiredForAll(clientModel);
    }

    @Override
    public void beforeUpdate(ClientRegistrationContext context, ClientModel clientModel) throws ClientRegistrationPolicyException {
        this.testMappers(context);
    }

    @Override
    public void afterUpdate(ClientRegistrationContext context, ClientModel clientModel) {
        this.enableConsentRequiredForAll(clientModel);
    }

    @Override
    public void beforeView(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    @Override
    public void beforeDelete(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    private List<String> getAllowedMapperProviders() {
        return this.componentModel.getConfig().getList((Object)"allowed-protocol-mapper-types");
    }

    private boolean isConsentRequiredForMappers() {
        String s = (String)this.componentModel.getConfig().getFirst((Object)"consent-required-for-all-mappers");
        return s == null || Boolean.parseBoolean(s);
    }
}

