/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessToken;

public class Auth {
    private final boolean cookie;
    private final RealmModel realm;
    private final AccessToken token;
    private final UserModel user;
    private final ClientModel client;
    private final UserSessionModel session;
    private AuthenticatedClientSessionModel clientSession;

    public Auth(RealmModel realm, AccessToken token, UserModel user, ClientModel client, UserSessionModel session, boolean cookie) {
        this.cookie = cookie;
        this.token = token;
        this.realm = realm;
        this.user = user;
        this.client = client;
        this.session = session;
    }

    public boolean isCookieAuthenticated() {
        return this.cookie;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public UserModel getUser() {
        return this.user;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public UserSessionModel getSession() {
        return this.session;
    }

    public AuthenticatedClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public void setClientSession(AuthenticatedClientSessionModel clientSession) {
        this.clientSession = clientSession;
    }

    public boolean hasRealmRole(String role) {
        if (this.cookie) {
            return this.user.hasRole(this.realm.getRole(role));
        }
        AccessToken.Access access = this.token.getRealmAccess();
        return access != null && access.isUserInRole(role);
    }

    public boolean hasOneOfRealmRole(String ... roles) {
        for (String r : roles) {
            if (!this.hasRealmRole(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasClientRole(ClientModel app, String role) {
        if (this.cookie) {
            return this.user.hasRole(app.getRole(role));
        }
        AccessToken.Access access = this.token.getResourceAccess(app.getClientId());
        return access != null && access.isUserInRole(role);
    }

    public boolean hasOneOfAppRole(ClientModel app, String ... roles) {
        for (String r : roles) {
            if (!this.hasClientRole(app, r)) continue;
            return true;
        }
        return false;
    }
}

