/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;

public class ClientTemplatesClientRegistrationPolicy
implements ClientRegistrationPolicy {
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ClientTemplatesClientRegistrationPolicy(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    @Override
    public void beforeRegister(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
        String clientTemplate = context.getClient().getClientTemplate();
        if (!this.isTemplateAllowed(clientTemplate)) {
            throw new ClientRegistrationPolicyException("Not permitted to use specified clientTemplate");
        }
    }

    @Override
    public void afterRegister(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeUpdate(ClientRegistrationContext context, ClientModel clientModel) throws ClientRegistrationPolicyException {
        String newTemplate = context.getClient().getClientTemplate();
        ClientTemplateModel currentTemplate = clientModel.getClientTemplate();
        if (!(currentTemplate != null && currentTemplate.getName().equals(newTemplate) || this.isTemplateAllowed(newTemplate))) {
            throw new ClientRegistrationPolicyException("Not permitted to use specified clientTemplate");
        }
    }

    @Override
    public void afterUpdate(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeView(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    @Override
    public void beforeDelete(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    private boolean isTemplateAllowed(String template) {
        if (template == null) {
            return true;
        }
        List allowedTemplates = this.componentModel.getConfig().getList((Object)"allowed-client-templates");
        return allowedTemplates.contains(template);
    }
}

