/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.net.URI;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.resources.AccountService;

public class AccountFederatedIdentityBean {
    private final List<FederatedIdentityEntry> identities;
    private final boolean removeLinkPossible;
    private final KeycloakSession session;

    public AccountFederatedIdentityBean(KeycloakSession session, RealmModel realm, UserModel user, URI baseUri, String stateChecker) {
        this.session = session;
        List identityProviders = realm.getIdentityProviders();
        Set identities = session.users().getFederatedIdentities(user, realm);
        TreeSet<FederatedIdentityEntry> orderedSet = new TreeSet<FederatedIdentityEntry>(IdentityProviderComparator.INSTANCE);
        int availableIdentities = 0;
        if (identityProviders != null && !identityProviders.isEmpty()) {
            for (IdentityProviderModel provider : identityProviders) {
                String providerId = provider.getAlias();
                FederatedIdentityModel identity = this.getIdentity(identities, providerId);
                if (identity != null) {
                    ++availableIdentities;
                }
                String displayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)session, (IdentityProviderModel)provider);
                FederatedIdentityEntry entry = new FederatedIdentityEntry(identity, displayName, provider.getAlias(), provider.getAlias(), provider.getConfig() != null ? (String)provider.getConfig().get("guiOrder") : null);
                orderedSet.add(entry);
            }
        }
        this.identities = new LinkedList<FederatedIdentityEntry>(orderedSet);
        this.removeLinkPossible = availableIdentities > 1 || user.getFederationLink() != null || AccountService.isPasswordSet(session, realm, user);
    }

    private FederatedIdentityModel getIdentity(Set<FederatedIdentityModel> identities, String providerId) {
        for (FederatedIdentityModel link : identities) {
            if (!providerId.equals(link.getIdentityProvider())) continue;
            return link;
        }
        return null;
    }

    public List<FederatedIdentityEntry> getIdentities() {
        return this.identities;
    }

    public boolean isRemoveLinkPossible() {
        return this.removeLinkPossible;
    }

    public static class IdentityProviderComparator
    implements Comparator<FederatedIdentityEntry> {
        public static IdentityProviderComparator INSTANCE = new IdentityProviderComparator();

        private IdentityProviderComparator() {
        }

        @Override
        public int compare(FederatedIdentityEntry o1, FederatedIdentityEntry o2) {
            int o2order;
            int o1order = this.parseOrder(o1);
            if (o1order > (o2order = this.parseOrder(o2))) {
                return 1;
            }
            if (o1order < o2order) {
                return -1;
            }
            return 1;
        }

        private int parseOrder(FederatedIdentityEntry ip) {
            if (ip != null && ip.getGuiOrder() != null) {
                try {
                    return Integer.parseInt(ip.getGuiOrder());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 10000;
        }
    }

    public class FederatedIdentityEntry {
        private FederatedIdentityModel federatedIdentityModel;
        private final String providerId;
        private final String providerName;
        private final String guiOrder;
        private final String displayName;

        public FederatedIdentityEntry(FederatedIdentityModel federatedIdentityModel, String displayName, String providerId, String providerName, String guiOrder) {
            this.federatedIdentityModel = federatedIdentityModel;
            this.displayName = displayName;
            this.providerId = providerId;
            this.providerName = providerName;
            this.guiOrder = guiOrder;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public String getUserId() {
            return this.federatedIdentityModel != null ? this.federatedIdentityModel.getUserId() : null;
        }

        public String getUserName() {
            return this.federatedIdentityModel != null ? this.federatedIdentityModel.getUserName() : null;
        }

        public boolean isConnected() {
            return this.federatedIdentityModel != null;
        }

        public String getGuiOrder() {
            return this.guiOrder;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

