/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.UriInfo;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.DefaultActionTokenKey;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.ActionTokenValueModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.Urls;

public class DefaultActionToken
extends DefaultActionTokenKey
implements ActionTokenValueModel {
    public static final String JSON_FIELD_AUTHENTICATION_SESSION_ID = "asid";
    public static final TokenVerifier.Predicate<DefaultActionTokenKey> ACTION_TOKEN_BASIC_CHECKS = t -> {
        if (t.getActionVerificationNonce() == null) {
            throw new VerificationException("Nonce not present.");
        }
        return true;
    };

    public DefaultActionToken() {
        super(null, null, 0, null);
    }

    protected DefaultActionToken(String userId, String actionId, int absoluteExpirationInSecs, UUID actionVerificationNonce) {
        super(userId, actionId, absoluteExpirationInSecs, actionVerificationNonce);
    }

    protected DefaultActionToken(String userId, String actionId, int absoluteExpirationInSecs, UUID actionVerificationNonce, String authenticationSessionId) {
        super(userId, actionId, absoluteExpirationInSecs, actionVerificationNonce);
        this.setAuthenticationSessionId(authenticationSessionId);
    }

    @JsonProperty(value="asid")
    public String getAuthenticationSessionId() {
        return (String)this.getOtherClaims().get(JSON_FIELD_AUTHENTICATION_SESSION_ID);
    }

    @JsonProperty(value="asid")
    public final void setAuthenticationSessionId(String authenticationSessionId) {
        this.setOtherClaims(JSON_FIELD_AUTHENTICATION_SESSION_ID, authenticationSessionId);
    }

    @JsonIgnore
    public Map<String, String> getNotes() {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.getAuthenticationSessionId() != null) {
            res.put(JSON_FIELD_AUTHENTICATION_SESSION_ID, this.getAuthenticationSessionId());
        }
        return res;
    }

    public String getNote(String name) {
        Object res = this.getOtherClaims().get(name);
        return res instanceof String ? (String)res : null;
    }

    public final String setNote(String name, String value) {
        Object res = value == null ? this.getOtherClaims().remove(name) : this.getOtherClaims().put(name, value);
        return res instanceof String ? (String)res : null;
    }

    public final String removeNote(String name) {
        Object res = this.getOtherClaims().remove(name);
        return res instanceof String ? (String)res : null;
    }

    public String serialize(KeycloakSession session, RealmModel realm, UriInfo uri) {
        String issuerUri = DefaultActionToken.getIssuer(realm, uri);
        KeyManager.ActiveHmacKey keys = session.keys().getActiveHmacKey(realm);
        this.issuedAt(Time.currentTime()).id(this.getActionVerificationNonce().toString()).issuer(issuerUri).audience(new String[]{issuerUri});
        return new JWSBuilder().kid(keys.getKid()).jsonContent((Object)this).hmac512(keys.getSecretKey());
    }

    private static String getIssuer(RealmModel realm, UriInfo uri) {
        return Urls.realmIssuer(uri.getBaseUri(), realm.getName());
    }
}

