/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints.request;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;

abstract class AuthzEndpointRequestParser {
    private static final Logger logger = Logger.getLogger(AuthzEndpointRequestParser.class);
    public static final int ADDITIONAL_REQ_PARAMS_MAX_MUMBER = 5;
    public static final int ADDITIONAL_REQ_PARAMS_MAX_SIZE = 200;
    private static final Set<String> KNOWN_REQ_PARAMS = new HashSet<String>();

    AuthzEndpointRequestParser() {
    }

    public void parseRequest(AuthorizationEndpointRequest request) {
        String clientId = this.getParameter("client_id");
        if (request.clientId != null && !request.clientId.equals(clientId)) {
            throw new IllegalArgumentException("The client_id parameter doesn't match the one from OIDC 'request' or 'request_uri'");
        }
        request.clientId = clientId;
        request.responseType = this.replaceIfNotNull(request.responseType, this.getParameter("response_type"));
        request.responseMode = this.replaceIfNotNull(request.responseMode, this.getParameter("response_mode"));
        request.redirectUriParam = this.replaceIfNotNull(request.redirectUriParam, this.getParameter("redirect_uri"));
        request.state = this.replaceIfNotNull(request.state, this.getParameter("state"));
        request.scope = this.replaceIfNotNull(request.scope, this.getParameter("scope"));
        request.loginHint = this.replaceIfNotNull(request.loginHint, this.getParameter("login_hint"));
        request.prompt = this.replaceIfNotNull(request.prompt, this.getParameter("prompt"));
        request.idpHint = this.replaceIfNotNull(request.idpHint, this.getParameter("kc_idp_hint"));
        request.nonce = this.replaceIfNotNull(request.nonce, this.getParameter("nonce"));
        request.maxAge = this.replaceIfNotNull(request.maxAge, this.getIntParameter("max_age"));
        request.claims = this.replaceIfNotNull(request.claims, this.getParameter("claims"));
        request.acr = this.replaceIfNotNull(request.acr, this.getParameter("acr_values"));
        request.codeChallenge = this.replaceIfNotNull(request.codeChallenge, this.getParameter("code_challenge"));
        request.codeChallengeMethod = this.replaceIfNotNull(request.codeChallengeMethod, this.getParameter("code_challenge_method"));
        this.extractAdditionalReqParams(request.additionalReqParams);
    }

    protected void extractAdditionalReqParams(Map<String, String> additionalReqParams) {
        for (String paramName : this.keySet()) {
            if (KNOWN_REQ_PARAMS.contains(paramName)) continue;
            String value = this.getParameter(paramName);
            if (value != null && value.trim().isEmpty()) {
                value = null;
            }
            if (value != null && value.length() <= 200) {
                if (additionalReqParams.size() >= 5) {
                    logger.debug((Object)"Maximal number of additional OIDC params (5) exceeded, ignoring rest of them!");
                    break;
                }
                additionalReqParams.put(paramName, value);
                continue;
            }
            logger.debug((Object)("OIDC Additional param " + paramName + " ignored because value is empty or longer than " + 200));
        }
    }

    protected <T> T replaceIfNotNull(T previousVal, T newVal) {
        return newVal == null ? previousVal : newVal;
    }

    protected abstract String getParameter(String var1);

    protected abstract Integer getIntParameter(String var1);

    protected abstract Set<String> keySet();

    static {
        KNOWN_REQ_PARAMS.add("client_id");
        KNOWN_REQ_PARAMS.add("response_type");
        KNOWN_REQ_PARAMS.add("response_mode");
        KNOWN_REQ_PARAMS.add("redirect_uri");
        KNOWN_REQ_PARAMS.add("state");
        KNOWN_REQ_PARAMS.add("scope");
        KNOWN_REQ_PARAMS.add("login_hint");
        KNOWN_REQ_PARAMS.add("prompt");
        KNOWN_REQ_PARAMS.add("kc_idp_hint");
        KNOWN_REQ_PARAMS.add("nonce");
        KNOWN_REQ_PARAMS.add("max_age");
        KNOWN_REQ_PARAMS.add("ui_locales");
        KNOWN_REQ_PARAMS.add("request");
        KNOWN_REQ_PARAMS.add("request_uri");
        KNOWN_REQ_PARAMS.add("claims");
        KNOWN_REQ_PARAMS.add("acr_values");
        KNOWN_REQ_PARAMS.add("code_challenge");
        KNOWN_REQ_PARAMS.add("code_challenge_method");
    }
}

