/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.validation.Validation;
import org.keycloak.util.JsonSerialization;

public class RegistrationRecaptcha
implements FormAction,
FormActionFactory,
ConfiguredProvider {
    public static final String G_RECAPTCHA_RESPONSE = "g-recaptcha-response";
    public static final String RECAPTCHA_REFERENCE_CATEGORY = "recaptcha";
    public static final String SITE_KEY = "site.key";
    public static final String SITE_SECRET = "secret";
    private static final Logger logger = Logger.getLogger(RegistrationRecaptcha.class);
    public static final String PROVIDER_ID = "registration-recaptcha-action";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getDisplayType() {
        return "Recaptcha";
    }

    public String getReferenceCategory() {
        return RECAPTCHA_REFERENCE_CATEGORY;
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        AuthenticatorConfigModel captchaConfig = context.getAuthenticatorConfig();
        if (captchaConfig == null || captchaConfig.getConfig() == null || captchaConfig.getConfig().get(SITE_KEY) == null || captchaConfig.getConfig().get(SITE_SECRET) == null) {
            form.addError(new FormMessage(null, "recaptchaNotConfigured"));
            return;
        }
        String siteKey = (String)captchaConfig.getConfig().get(SITE_KEY);
        form.setAttribute("recaptchaRequired", (Object)true);
        form.setAttribute("recaptchaSiteKey", (Object)siteKey);
        form.addScript("https://www.google.com/recaptcha/api.js");
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        boolean success = false;
        context.getEvent().detail("register_method", "form");
        String captcha = (String)formData.getFirst((Object)G_RECAPTCHA_RESPONSE);
        if (!Validation.isBlank(captcha)) {
            AuthenticatorConfigModel captchaConfig = context.getAuthenticatorConfig();
            String secret = (String)captchaConfig.getConfig().get(SITE_SECRET);
            success = this.validateRecaptcha(context, success, captcha, secret);
        }
        if (!success) {
            errors.add(new FormMessage(null, "recaptchaFailed"));
            formData.remove((Object)G_RECAPTCHA_RESPONSE);
            context.error("invalid_registration");
            context.validationError(formData, errors);
            context.excludeOtherErrors();
            return;
        }
        context.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateRecaptcha(ValidationContext context, boolean success, String captcha, String secret) {
        HttpClient httpClient = ((HttpClientProvider)context.getSession().getProvider(HttpClientProvider.class)).getHttpClient();
        HttpPost post = new HttpPost("https://www.google.com/recaptcha/api/siteverify");
        LinkedList<BasicNameValuePair> formparams = new LinkedList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair(SITE_SECRET, secret));
        formparams.add(new BasicNameValuePair("response", captcha));
        formparams.add(new BasicNameValuePair("remoteip", context.getConnection().getRemoteAddr()));
        try {
            UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
            post.setEntity((HttpEntity)form);
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            try (InputStream content = response.getEntity().getContent();){
                Map json = (Map)JsonSerialization.readValue((InputStream)content, Map.class);
                Object val = json.get("success");
                success = Boolean.TRUE.equals(val);
            }
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.recaptchaFailed(e);
        }
        return success;
    }

    public void success(FormContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Adds Google Recaptcha button.  Recaptchas verify that the entity that is registering is a human.  This can only be used on the internet and must be configured after you add it.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(SITE_KEY);
        property.setLabel("Recaptcha Site Key");
        property.setType("String");
        property.setHelpText("Google Recaptcha Site Key");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(SITE_SECRET);
        property.setLabel("Recaptcha Secret");
        property.setType("String");
        property.setHelpText("Google Recaptcha Secret");
        configProperties.add(property);
    }
}

