/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.Time;
import org.keycloak.keys.FailsafeHmacKeyProvider;
import org.keycloak.keys.SecretKeyMetadata;
import org.keycloak.keys.SecretKeyProvider;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class FailsafeSecretKeyProvider
implements SecretKeyProvider {
    private static String KID;
    private static SecretKey KEY;
    private static long EXPIRES;
    private SecretKey key;
    private String kid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailsafeSecretKeyProvider() {
        this.logger().errorv("No active keys found, using failsafe provider, please login to admin console to add keys. Clustering is not supported.", new Object[0]);
        Class<FailsafeHmacKeyProvider> clazz = FailsafeHmacKeyProvider.class;
        synchronized (FailsafeHmacKeyProvider.class) {
            if (EXPIRES < (long)Time.currentTime()) {
                KEY = KeyUtils.loadSecretKey((byte[])KeycloakModelUtils.generateSecret((int)32), (String)this.getJavaAlgorithmName());
                KID = KeycloakModelUtils.generateId();
                EXPIRES = Time.currentTime() + 600;
                if (EXPIRES > 0L) {
                    this.logger().warnv("Keys expired, re-generated kid={0}", (Object)KID);
                }
            }
            this.kid = KID;
            this.key = KEY;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getKid() {
        return this.kid;
    }

    public SecretKey getSecretKey() {
        return this.key;
    }

    public SecretKey getSecretKey(String kid) {
        return kid.equals(this.kid) ? this.key : null;
    }

    public List<SecretKeyMetadata> getKeyMetadata() {
        return Collections.emptyList();
    }

    public void close() {
    }

    protected abstract Logger logger();
}

