/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.List;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.partialimport.AbstractPartialImport;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.RoleResource;

public class RealmRolesPartialImport
extends AbstractPartialImport<RoleRepresentation> {
    public Set<RoleRepresentation> getToOverwrite() {
        return this.toOverwrite;
    }

    public Set<RoleRepresentation> getToSkip() {
        return this.toSkip;
    }

    @Override
    public List<RoleRepresentation> getRepList(PartialImportRepresentation partialImportRep) {
        if (partialImportRep.getRoles() == null) {
            return null;
        }
        return partialImportRep.getRoles().getRealm();
    }

    @Override
    public String getName(RoleRepresentation roleRep) {
        if (roleRep.getName() == null) {
            throw new IllegalStateException("Realm role to import does not have a name");
        }
        return roleRep.getName();
    }

    @Override
    public String getModelId(RealmModel realm, KeycloakSession session, RoleRepresentation roleRep) {
        for (RoleModel role : realm.getRoles()) {
            if (!this.getName(roleRep).equals(role.getName())) continue;
            return role.getId();
        }
        return null;
    }

    @Override
    public boolean exists(RealmModel realm, KeycloakSession session, RoleRepresentation roleRep) {
        for (RoleModel role : realm.getRoles()) {
            if (!this.getName(roleRep).equals(role.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String existsMessage(RealmModel realm, RoleRepresentation roleRep) {
        return "Realm role '" + this.getName(roleRep) + "' already exists.";
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.REALM_ROLE;
    }

    @Override
    public void remove(RealmModel realm, KeycloakSession session, RoleRepresentation roleRep) {
        RoleModel role = realm.getRole(this.getName(roleRep));
        RoleHelper helper = new RoleHelper(realm);
        helper.deleteRole(role);
    }

    @Override
    public void create(RealmModel realm, KeycloakSession session, RoleRepresentation roleRep) {
        realm.addRole(this.getName(roleRep));
    }

    public static class RoleHelper
    extends RoleResource {
        public RoleHelper(RealmModel realm) {
            super(realm);
        }

        @Override
        protected void deleteRole(RoleModel role) {
            super.deleteRole(role);
        }
    }
}

