/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientregistration.policy.AbstractClientRegistrationPolicyFactory;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.impl.ClientTemplatesClientRegistrationPolicy;

public class ClientTemplatesClientRegistrationPolicyFactory
extends AbstractClientRegistrationPolicyFactory {
    private List<ProviderConfigProperty> configProperties;
    public static final String PROVIDER_ID = "allowed-client-templates";
    public static final String ALLOWED_CLIENT_TEMPLATES = "allowed-client-templates";

    public ClientRegistrationPolicy create(KeycloakSession session, ComponentModel model) {
        return new ClientTemplatesClientRegistrationPolicy(session, model);
    }

    public String getHelpText() {
        return "When present, it allows to specify whitelist of client templates, which will be allowed in representation of registered (or updated) client";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties(KeycloakSession session) {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("allowed-client-templates");
        property.setLabel("allowed-client-templates.label");
        property.setHelpText("allowed-client-templates.tooltip");
        property.setType("MultivaluedList");
        if (session != null) {
            property.setOptions(this.getClientTemplates(session));
        }
        this.configProperties = Collections.singletonList(property);
        return this.configProperties;
    }

    private List<String> getClientTemplates(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        if (realm == null) {
            return Collections.emptyList();
        }
        List clientTemplates = realm.getClientTemplates();
        return clientTemplates.stream().map(clientTemplate -> clientTemplate.getName()).collect(Collectors.toList());
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.getConfigProperties(null);
    }

    public String getId() {
        return "allowed-client-templates";
    }
}

