/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection;

import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.protection.permission.PermissionService;
import org.keycloak.authorization.protection.resource.ResourceService;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminEventBuilder;

public class ProtectionService {
    private final AuthorizationProvider authorization;
    @Context
    protected ClientConnection clientConnection;

    public ProtectionService(AuthorizationProvider authorization) {
        this.authorization = authorization;
    }

    @Path(value="/resource_set")
    public Object resource() {
        KeycloakIdentity identity = this.createIdentity(true);
        ResourceServer resourceServer = this.getResourceServer(identity);
        RealmModel realm = this.authorization.getRealm();
        ClientModel client = realm.getClientById(identity.getId());
        KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
        UserModel serviceAccount = keycloakSession.users().getServiceAccount(client);
        AdminEventBuilder adminEvent = new AdminEventBuilder(realm, new AdminAuth(realm, identity.getAccessToken(), serviceAccount, client), keycloakSession, this.clientConnection);
        ResourceSetService resourceManager = new ResourceSetService(resourceServer, this.authorization, null, adminEvent.realm(realm).authClient(client).authUser(serviceAccount));
        ResteasyProviderFactory.getInstance().injectProperties((Object)resourceManager);
        ResourceService resource = new ResourceService(resourceServer, identity, resourceManager, this.authorization);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/permission")
    public Object permission() {
        KeycloakIdentity identity = this.createIdentity(false);
        PermissionService resource = new PermissionService(identity, this.getResourceServer(identity), this.authorization);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    private KeycloakIdentity createIdentity(boolean checkProtectionScope) {
        KeycloakIdentity identity = new KeycloakIdentity(this.authorization.getKeycloakSession());
        ResourceServer resourceServer = this.getResourceServer(identity);
        KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
        RealmModel realm = keycloakSession.getContext().getRealm();
        ClientModel client = realm.getClientById(resourceServer.getId());
        if (checkProtectionScope && !identity.hasClientRole(client.getClientId(), "uma_protection")) {
            throw new ErrorResponseException("invalid_scope", "Requires uma_protection scope.", Response.Status.FORBIDDEN);
        }
        return identity;
    }

    private ResourceServer getResourceServer(KeycloakIdentity identity) {
        String clientId = identity.getAccessToken().getIssuedFor();
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        ClientModel clientModel = realm.getClientByClientId(clientId);
        if (clientModel == null && (clientModel = realm.getClientById(clientId)) == null) {
            throw new ErrorResponseException("invalid_clientId", "Client application with id [" + clientId + "] does not exist in realm [" + realm.getName() + "]", Response.Status.BAD_REQUEST);
        }
        ResourceServer resourceServer = this.authorization.getStoreFactory().getResourceServerStore().findById(clientModel.getId());
        if (resourceServer == null) {
            throw new ErrorResponseException("invalid_clientId", "Client application [" + clientModel.getClientId() + "] is not registered as a resource server.", Response.Status.FORBIDDEN);
        }
        return resourceServer;
    }
}

