/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.validation;

import java.text.MessageFormat;
import java.util.Properties;

public class ValidationMessage {
    private String fieldId;
    private String message;
    private String localizedMessageKey;
    private Object[] localizedMessageParameters;

    public ValidationMessage(String message) {
        this.message = message;
    }

    public ValidationMessage(String message, String localizedMessageKey, Object ... localizedMessageParameters) {
        this.message = message;
        this.localizedMessageKey = localizedMessageKey;
        this.localizedMessageParameters = localizedMessageParameters;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getLocalizedMessageKey() {
        return this.localizedMessageKey;
    }

    public void setLocalizedMessageKey(String localizedMessageKey) {
        this.localizedMessageKey = localizedMessageKey;
    }

    public Object[] getLocalizedMessageParameters() {
        return this.localizedMessageParameters;
    }

    public void setLocalizedMessageParameters(Object[] localizedMessageParameters) {
        this.localizedMessageParameters = localizedMessageParameters;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(Properties localizedMessages) {
        if (this.getLocalizedMessageKey() != null) {
            return MessageFormat.format(localizedMessages.getProperty(this.getLocalizedMessageKey(), this.getMessage()), this.getLocalizedMessageParameters());
        }
        return this.getMessage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationMessage message1 = (ValidationMessage)o;
        if (this.getFieldId() != null ? !this.getFieldId().equals(message1.getFieldId()) : message1.getFieldId() != null) {
            return false;
        }
        return this.getMessage() != null ? this.getMessage().equals(message1.getMessage()) : message1.getMessage() == null;
    }

    public int hashCode() {
        int result = this.getFieldId() != null ? this.getFieldId().hashCode() : 0;
        result = 31 * result + (this.getMessage() != null ? this.getMessage().hashCode() : 0);
        return result;
    }
}

