/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.oidc;

import java.net.URI;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.mappers.PairwiseSubMapperHelper;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.protocol.oidc.utils.PairwiseSubMapperUtils;
import org.keycloak.protocol.oidc.utils.SubjectType;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.clientregistration.ClientRegistrationException;
import org.keycloak.services.util.CertificateInfoHelper;
import org.keycloak.util.JWKSUtils;

public class DescriptionConverter {
    public static ClientRepresentation toInternal(KeycloakSession session, OIDCClientRepresentation clientOIDC) throws ClientRegistrationException {
        Boolean tlsClientCertificateBoundAccessTokens;
        Algorithm algorithm;
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientOIDC.getClientId());
        client.setName(clientOIDC.getClientName());
        client.setRedirectUris(clientOIDC.getRedirectUris());
        client.setBaseUrl(clientOIDC.getClientUri());
        List<String> oidcResponseTypes = clientOIDC.getResponseTypes();
        if (oidcResponseTypes == null || oidcResponseTypes.isEmpty()) {
            oidcResponseTypes = Collections.singletonList("code");
        }
        List oidcGrantTypes = clientOIDC.getGrantTypes();
        try {
            OIDCResponseType responseType = OIDCResponseType.parse(oidcResponseTypes);
            client.setStandardFlowEnabled(Boolean.valueOf(responseType.hasResponseType("code")));
            client.setImplicitFlowEnabled(Boolean.valueOf(responseType.isImplicitOrHybridFlow()));
            client.setPublicClient(Boolean.valueOf(responseType.isImplicitFlow()));
            if (oidcGrantTypes != null) {
                client.setDirectAccessGrantsEnabled(Boolean.valueOf(oidcGrantTypes.contains("password")));
                client.setServiceAccountsEnabled(Boolean.valueOf(oidcGrantTypes.contains("client_credentials")));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ClientRegistrationException(iae.getMessage(), iae);
        }
        String authMethod = clientOIDC.getTokenEndpointAuthMethod();
        ClientAuthenticatorFactory clientAuthFactory = authMethod == null ? (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, KeycloakModelUtils.getDefaultClientAuthenticatorType()) : AuthorizeClientUtil.findClientAuthenticatorForOIDCAuthMethod(session, authMethod);
        if (clientAuthFactory == null) {
            throw new ClientRegistrationException("Not found clientAuthenticator for requested token_endpoint_auth_method");
        }
        client.setClientAuthenticatorType(clientAuthFactory.getId());
        boolean publicKeySet = DescriptionConverter.setPublicKey(clientOIDC, client);
        if (authMethod != null && authMethod.equals("private_key_jwt") && !publicKeySet) {
            throw new ClientRegistrationException("Didn't find key of supported keyType for use " + JWK.Use.SIG.asString());
        }
        OIDCAdvancedConfigWrapper configWrapper = OIDCAdvancedConfigWrapper.fromClientRepresentation(client);
        if (clientOIDC.getUserinfoSignedResponseAlg() != null) {
            algorithm = Enum.valueOf(Algorithm.class, clientOIDC.getUserinfoSignedResponseAlg());
            configWrapper.setUserInfoSignedResponseAlg(algorithm);
        }
        if (clientOIDC.getRequestObjectSigningAlg() != null) {
            algorithm = Enum.valueOf(Algorithm.class, clientOIDC.getRequestObjectSigningAlg());
            configWrapper.setRequestObjectSignatureAlg(algorithm);
        }
        if ((tlsClientCertificateBoundAccessTokens = clientOIDC.getTlsClientCertificateBoundAccessTokens()) != null) {
            if (tlsClientCertificateBoundAccessTokens.booleanValue()) {
                configWrapper.setUseMtlsHoKToken(true);
            } else {
                configWrapper.setUseMtlsHoKToken(false);
            }
        }
        return client;
    }

    private static boolean setPublicKey(OIDCClientRepresentation clientOIDC, ClientRepresentation clientRep) {
        if (clientOIDC.getJwksUri() == null && clientOIDC.getJwks() == null) {
            return false;
        }
        if (clientOIDC.getJwksUri() != null && clientOIDC.getJwks() != null) {
            throw new ClientRegistrationException("Illegal to use both jwks_uri and jwks");
        }
        OIDCAdvancedConfigWrapper configWrapper = OIDCAdvancedConfigWrapper.fromClientRepresentation(clientRep);
        if (clientOIDC.getJwks() != null) {
            JSONWebKeySet keySet = clientOIDC.getJwks();
            JWK publicKeyJWk = JWKSUtils.getKeyForUse((JSONWebKeySet)keySet, (JWK.Use)JWK.Use.SIG);
            if (publicKeyJWk == null) {
                return false;
            }
            PublicKey publicKey = JWKParser.create((JWK)publicKeyJWk).toPublicKey();
            String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
            CertificateRepresentation rep = new CertificateRepresentation();
            rep.setPublicKey(publicKeyPem);
            rep.setKid(publicKeyJWk.getKeyId());
            CertificateInfoHelper.updateClientRepresentationCertificateInfo(clientRep, rep, "jwt.credential");
            configWrapper.setUseJwksUrl(false);
            return true;
        }
        configWrapper.setUseJwksUrl(true);
        configWrapper.setJwksUrl(clientOIDC.getJwksUri());
        return true;
    }

    public static OIDCClientRepresentation toExternalResponse(KeycloakSession session, ClientRepresentation client, URI uri) {
        OIDCClientRepresentation response = new OIDCClientRepresentation();
        response.setClientId(client.getClientId());
        ClientAuthenticatorFactory clientAuth = (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, client.getClientAuthenticatorType());
        Set oidcClientAuthMethods = clientAuth.getProtocolAuthenticatorMethods("openid-connect");
        if (oidcClientAuthMethods != null && !oidcClientAuthMethods.isEmpty()) {
            response.setTokenEndpointAuthMethod((String)oidcClientAuthMethods.iterator().next());
        }
        if (client.getClientAuthenticatorType().equals("client-secret")) {
            response.setClientSecret(client.getSecret());
            response.setClientSecretExpiresAt(Integer.valueOf(0));
        }
        response.setClientName(client.getName());
        response.setClientUri(client.getBaseUrl());
        response.setRedirectUris(client.getRedirectUris());
        response.setRegistrationAccessToken(client.getRegistrationAccessToken());
        response.setRegistrationClientUri(uri.toString());
        response.setResponseTypes(DescriptionConverter.getOIDCResponseTypes(client));
        response.setGrantTypes(DescriptionConverter.getOIDCGrantTypes(client));
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation(client);
        if (config.isUserInfoSignatureRequired()) {
            response.setUserinfoSignedResponseAlg(config.getUserInfoSignedResponseAlg().toString());
        }
        if (config.getRequestObjectSignatureAlg() != null) {
            response.setRequestObjectSigningAlg(config.getRequestObjectSignatureAlg().toString());
        }
        if (config.isUseJwksUrl()) {
            response.setJwksUri(config.getJwksUrl());
        }
        if (config.isUseMtlsHokToken()) {
            response.setTlsClientCertificateBoundAccessTokens(Boolean.TRUE);
        } else {
            response.setTlsClientCertificateBoundAccessTokens(Boolean.FALSE);
        }
        List<ProtocolMapperRepresentation> foundPairwiseMappers = PairwiseSubMapperUtils.getPairwiseSubMappers(client);
        SubjectType subjectType = foundPairwiseMappers.isEmpty() ? SubjectType.PUBLIC : SubjectType.PAIRWISE;
        response.setSubjectType(subjectType.toString().toLowerCase());
        if (subjectType.equals((Object)SubjectType.PAIRWISE)) {
            String sectorIdentifierUri = PairwiseSubMapperHelper.getSectorIdentifierUri(foundPairwiseMappers.get(0));
            response.setSectorIdentifierUri(sectorIdentifierUri);
        }
        return response;
    }

    private static List<String> getOIDCResponseTypes(ClientRepresentation client) {
        ArrayList<String> responseTypes = new ArrayList<String>();
        if (client.isStandardFlowEnabled().booleanValue()) {
            responseTypes.add("code");
            responseTypes.add("none");
        }
        if (client.isImplicitFlowEnabled().booleanValue()) {
            responseTypes.add("id_token");
            responseTypes.add("id_token token");
        }
        if (client.isStandardFlowEnabled().booleanValue() && client.isImplicitFlowEnabled().booleanValue()) {
            responseTypes.add("code id_token");
            responseTypes.add("code token");
            responseTypes.add("code id_token token");
        }
        return responseTypes;
    }

    private static List<String> getOIDCGrantTypes(ClientRepresentation client) {
        ArrayList<String> grantTypes = new ArrayList<String>();
        if (client.isStandardFlowEnabled().booleanValue()) {
            grantTypes.add("authorization_code");
        }
        if (client.isImplicitFlowEnabled().booleanValue()) {
            grantTypes.add("implicit");
        }
        if (client.isDirectAccessGrantsEnabled().booleanValue()) {
            grantTypes.add("password");
        }
        if (client.isServiceAccountsEnabled().booleanValue()) {
            grantTypes.add("client_credentials");
        }
        grantTypes.add("refresh_token");
        return grantTypes;
    }
}

