/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.keycloak.provider.DefaultProviderLoader;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.ProviderLoader;
import org.keycloak.provider.ProviderLoaderFactory;

public class FileSystemProviderLoaderFactory
implements ProviderLoaderFactory {
    private static final Logger logger = Logger.getLogger(FileSystemProviderLoaderFactory.class);

    public boolean supports(String type) {
        return "classpath".equals(type);
    }

    public ProviderLoader create(KeycloakDeploymentInfo info, ClassLoader baseClassLoader, String resource) {
        return new DefaultProviderLoader(info, FileSystemProviderLoaderFactory.createClassLoader(baseClassLoader, resource.split(";")));
    }

    private static URLClassLoader createClassLoader(ClassLoader parent, String ... files) {
        try {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (String f : files) {
                if (f.endsWith("*")) {
                    File dir = new File(f.substring(0, f.length() - 1));
                    if (!dir.isDirectory()) continue;
                    for (File file : dir.listFiles(new JarFilter())) {
                        urls.add(file.toURI().toURL());
                    }
                    continue;
                }
                urls.add(new File(f).toURI().toURL());
            }
            logger.debug((Object)("Loading providers from " + ((Object)urls).toString()));
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }
}

