/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.UserResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class UsersResource {
    private static final Logger logger = Logger.getLogger(UsersResource.class);
    private static final String SEARCH_ID_PARAMETER = "id:";
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public UsersResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.resource(ResourceType.USER);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createUser(UserRepresentation rep) {
        this.auth.users().requireManage();
        if (this.session.users().getUserByUsername(rep.getUsername(), this.realm) != null) {
            return ErrorResponse.exists("User exists with same username");
        }
        if (rep.getEmail() != null && !this.realm.isDuplicateEmailsAllowed() && this.session.users().getUserByEmail(rep.getEmail(), this.realm) != null) {
            return ErrorResponse.exists("User exists with same email");
        }
        try {
            UserModel user = this.session.users().addUser(this.realm, rep.getUsername());
            Set<String> emptySet = Collections.emptySet();
            UserResource.updateUserFromRep(user, rep, emptySet, this.realm, this.session, false);
            RepresentationToModel.createCredentials((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user, (boolean)true);
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), user.getId()).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(user.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            return ErrorResponse.exists("User exists with same username or email");
        }
        catch (ModelException me) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            logger.warn((Object)"Could not create user", (Throwable)me);
            return ErrorResponse.exists("Could not create user");
        }
    }

    @Path(value="{id}")
    public UserResource user(@PathParam(value="id") String id) {
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("User not found");
            }
            throw new ForbiddenException();
        }
        UserResource resource = new UserResource(this.realm, user, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUsers(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.users().requireQuery();
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        ArrayList<UserRepresentation> results = new ArrayList<UserRepresentation>();
        List userModels = Collections.emptyList();
        if (search != null) {
            if (search.startsWith(SEARCH_ID_PARAMETER)) {
                UserModel userModel = this.session.users().getUserById(search.substring(SEARCH_ID_PARAMETER.length()).trim(), this.realm);
                if (userModel != null) {
                    userModels = Arrays.asList(userModel);
                }
            } else {
                userModels = this.session.users().searchForUser(search.trim(), this.realm, firstResult.intValue(), maxResults.intValue());
            }
        } else if (last != null || first != null || email != null || username != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (last != null) {
                attributes.put("lastName", last);
            }
            if (first != null) {
                attributes.put("firstName", first);
            }
            if (email != null) {
                attributes.put("email", email);
            }
            if (username != null) {
                attributes.put("username", username);
            }
            userModels = this.session.users().searchForUser(attributes, this.realm, firstResult.intValue(), maxResults.intValue());
        } else {
            userModels = this.session.users().getUsers(this.realm, firstResult.intValue(), maxResults.intValue(), false);
        }
        boolean canViewGlobal = this.auth.users().canView();
        for (UserModel user : userModels) {
            if (!canViewGlobal && !this.auth.users().canView(user)) continue;
            UserRepresentation userRep = ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user);
            userRep.setAccess(this.auth.users().getAccess(user));
            results.add(userRep);
        }
        return results;
    }

    @Path(value="count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Integer getUsersCount() {
        this.auth.users().requireView();
        return this.session.users().getUsersCount(this.realm);
    }
}

