/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.mappers.AudienceProtocolMapper;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientScopeResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientScopesResource {
    protected static final Logger logger = Logger.getLogger(ClientScopesResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;

    public ClientScopesResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_SCOPE);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<ClientScopeRepresentation> getClientScopes() {
        this.auth.clients().requireListClientScopes();
        ArrayList<ClientScopeRepresentation> rep = new ArrayList<ClientScopeRepresentation>();
        List clientModels = this.realm.getClientScopes();
        boolean viewable = this.auth.clients().canViewClientScopes();
        for (ClientScopeModel clientModel : clientModels) {
            if (viewable) {
                rep.add(ModelToRepresentation.toRepresentation((ClientScopeModel)clientModel));
                continue;
            }
            ClientScopeRepresentation tempRep = new ClientScopeRepresentation();
            tempRep.setName(clientModel.getName());
            tempRep.setId(clientModel.getId());
            tempRep.setProtocol(clientModel.getProtocol());
        }
        return rep;
    }

    @POST
    @Consumes(value={"application/json"})
    @NoCache
    public Response createClientScope(ClientScopeRepresentation rep) {
        this.auth.clients().requireManageClientScopes();
        try {
            ClientScopeModel clientModel = RepresentationToModel.createClientScope((KeycloakSession)this.session, (RealmModel)this.realm, (ClientScopeRepresentation)rep);
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), clientModel.getId()).representation(rep).success();
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(clientModel.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client Scope " + rep.getName() + " already exists");
        }
    }

    @Path(value="generate-audience-client-scope")
    @POST
    @NoCache
    public Response generateAudienceClientScope(@QueryParam(value="clientId") String clientId) {
        this.auth.clients().requireManageClientScopes();
        logger.debugf("Generating audience scope for service client: " + clientId, new Object[0]);
        String clientScopeName = clientId;
        try {
            ClientModel serviceClient = this.realm.getClientByClientId(clientId);
            if (serviceClient == null) {
                logger.warnf("Referenced service client '%s' doesn't exists", (Object)clientId);
                return ErrorResponse.exists("Referenced service client doesn't exists");
            }
            ClientScopeModel clientScopeModel = this.realm.addClientScope(clientScopeName);
            clientScopeModel.setDescription("Client scope useful for frontend clients, which want to call service " + clientId);
            clientScopeModel.setProtocol(serviceClient.getProtocol() == null ? "openid-connect" : serviceClient.getProtocol());
            clientScopeModel.setDisplayOnConsentScreen(true);
            String consentText = serviceClient.getName() != null ? serviceClient.getName() : serviceClient.getClientId();
            consentText = consentText.substring(0, 1).toUpperCase() + consentText.substring(1);
            clientScopeModel.setConsentScreenText(consentText);
            ProtocolMapperModel audienceMapper = AudienceProtocolMapper.createClaimMapper("Audience for " + clientId, clientId, null, true, false);
            clientScopeModel.addProtocolMapper(audienceMapper);
            for (RoleModel role : serviceClient.getRoles()) {
                clientScopeModel.addScopeMapping(role);
            }
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(clientScopeModel.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client Scope " + clientScopeName + " already exists");
        }
    }

    @Path(value="{id}")
    @NoCache
    public ClientScopeResource getClientScope(@PathParam(value="id") String id) {
        this.auth.clients().requireListClientScopes();
        ClientScopeModel clientModel = this.realm.getClientScopeById(id);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client scope");
        }
        ClientScopeResource clientResource = new ClientScopeResource(this.realm, this.auth, clientModel, this.session, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientResource);
        return clientResource;
    }
}

