/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.io.IOException;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.validation.Validation;
import org.keycloak.theme.Theme;

public class P3PHelper {
    private static final Logger logger = Logger.getLogger(P3PHelper.class);

    public static void addP3PHeader(KeycloakSession session) {
        try {
            Theme theme = session.theme().getTheme(Theme.Type.LOGIN);
            Locale locale = session.getContext().resolveLocale(null);
            String p3pValue = theme.getMessages(locale).getProperty("p3pPolicy");
            if (!Validation.isBlank(p3pValue)) {
                HttpResponse response = (HttpResponse)ResteasyProviderFactory.getContextData(HttpResponse.class);
                response.getOutputHeaders().putSingle((Object)"P3P", (Object)p3pValue);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to set P3P header", (Throwable)e);
            return;
        }
    }
}

