/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;

public class RoleContainerResource
extends RoleResource {
    private final RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected RoleContainerModel roleContainer;
    private AdminEventBuilder adminEvent;
    private UriInfo uriInfo;
    private KeycloakSession session;

    public RoleContainerResource(KeycloakSession session, UriInfo uriInfo, RealmModel realm, AdminPermissionEvaluator auth, RoleContainerModel roleContainer, AdminEventBuilder adminEvent) {
        super(realm);
        this.uriInfo = uriInfo;
        this.realm = realm;
        this.auth = auth;
        this.roleContainer = roleContainer;
        this.adminEvent = adminEvent;
        this.session = session;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<RoleRepresentation> getRoles() {
        this.auth.roles().requireList(this.roleContainer);
        Set roleModels = this.roleContainer.getRoles();
        ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roleModels) {
            roles.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
        }
        return roles;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createRole(RoleRepresentation rep) {
        this.auth.roles().requireManage(this.roleContainer);
        if (rep.getName() == null) {
            throw new BadRequestException();
        }
        try {
            RoleModel role = this.roleContainer.addRole(rep.getName());
            role.setDescription(rep.getDescription());
            rep.setId(role.getId());
            if (role.isClientRole()) {
                this.adminEvent.resource(ResourceType.CLIENT_ROLE);
            } else {
                this.adminEvent.resource(ResourceType.REALM_ROLE);
            }
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, role.getName()).representation(rep).success();
            return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(role.getName()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Role with name " + rep.getName() + " already exists");
        }
    }

    @Path(value="{role-name}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RoleRepresentation getRole(@PathParam(value="role-name") String roleName) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel roleModel = this.roleContainer.getRole(roleName);
        if (roleModel == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.getRole(roleModel);
    }

    @Path(value="{role-name}")
    @DELETE
    @NoCache
    public void deleteRole(@PathParam(value="role-name") String roleName) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        this.deleteRole(role);
        if (role.isClientRole()) {
            this.adminEvent.resource(ResourceType.CLIENT_ROLE);
        } else {
            this.adminEvent.resource(ResourceType.REALM_ROLE);
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="{role-name}")
    @PUT
    @Consumes(value={"application/json"})
    public Response updateRole(@PathParam(value="role-name") String roleName, RoleRepresentation rep) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        try {
            this.updateRole(rep, role);
            if (role.isClientRole()) {
                this.adminEvent.resource(ResourceType.CLIENT_ROLE);
            } else {
                this.adminEvent.resource(ResourceType.REALM_ROLE);
            }
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Role with name " + rep.getName() + " already exists");
        }
    }

    @Path(value="{role-name}/composites")
    @POST
    @Consumes(value={"application/json"})
    public void addComposites(@PathParam(value="role-name") String roleName, List<RoleRepresentation> roles) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        this.addComposites(this.auth, this.adminEvent, this.uriInfo, roles, role);
    }

    @Path(value="{role-name}/composites")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRoleComposites(@PathParam(value="role-name") String roleName) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.getRoleComposites(role);
    }

    @Path(value="{role-name}/composites/realm")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRealmRoleComposites(@PathParam(value="role-name") String roleName) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.getRealmRoleComposites(role);
    }

    @Path(value="{role-name}/composites/clients/{client}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getClientRoleComposites(@PathParam(value="role-name") String roleName, @PathParam(value="client") String client) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        ClientModel clientModel = this.realm.getClientById(client);
        if (client == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.getClientRoleComposites(clientModel, role);
    }

    @Path(value="{role-name}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteComposites(@PathParam(value="role-name") String roleName, List<RoleRepresentation> roles) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        this.deleteComposites(this.adminEvent, this.uriInfo, roles, role);
    }

    @Path(value="{role-name}/management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public ManagementPermissionReference getManagementPermissions(@PathParam(value="role-name") String roleName) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.roles().isPermissionsEnabled(role)) {
            return new ManagementPermissionReference();
        }
        return RoleByIdResource.toMgmtRef(role, permissions);
    }

    @Path(value="{role-name}/management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    public ManagementPermissionReference setManagementPermissionsEnabled(@PathParam(value="role-name") String roleName, ManagementPermissionReference ref) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.roles().setPermissionsEnabled(role, ref.isEnabled());
        if (ref.isEnabled()) {
            return RoleByIdResource.toMgmtRef(role, permissions);
        }
        return new ManagementPermissionReference();
    }

    @Path(value="{role-name}/users")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<UserRepresentation> getUsersInRole(@PathParam(value="role-name") String roleName, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.roles().requireView(this.roleContainer);
        firstResult = firstResult != null ? firstResult : 0;
        maxResults = maxResults != null ? maxResults : 100;
        RoleModel role = this.roleContainer.getRole(roleName);
        ArrayList<UserRepresentation> results = new ArrayList<UserRepresentation>();
        List userModels = this.session.users().getRoleMembers(this.realm, role, firstResult.intValue(), maxResults.intValue());
        for (UserModel user : userModels) {
            results.add(ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user));
        }
        return results;
    }
}

