/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.services.resources.admin.permissions.RealmPermissionEvaluator;

class RealmPermissions
implements RealmPermissionEvaluator {
    private static final Logger logger = Logger.getLogger(RealmPermissions.class);
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected final AuthorizationProvider authz;
    protected final MgmtPermissions root;

    public RealmPermissions(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissions root) {
        this.session = session;
        this.realm = realm;
        this.authz = authz;
        this.root = root;
    }

    public boolean canManageRealmDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_REALM);
    }

    public boolean canViewRealmDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_REALM, AdminRoles.VIEW_REALM);
    }

    public boolean canManageIdentityProvidersDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_IDENTITY_PROVIDERS);
    }

    public boolean canViewIdentityProvidersDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_IDENTITY_PROVIDERS, AdminRoles.VIEW_IDENTITY_PROVIDERS);
    }

    public boolean canManageAuthorizationDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_AUTHORIZATION, AdminRoles.MANAGE_CLIENTS);
    }

    public boolean canViewAuthorizationDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_AUTHORIZATION, AdminRoles.VIEW_AUTHORIZATION);
    }

    public boolean canManageEventsDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_EVENTS);
    }

    public boolean canViewEventsDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_EVENTS, AdminRoles.VIEW_EVENTS);
    }

    @Override
    public boolean canListRealms() {
        return this.canViewRealm() || this.root.hasOneAdminRole(AdminRoles.QUERY_REALMS);
    }

    @Override
    public void requireViewRealmNameList() {
        if (!this.canListRealms()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageRealm() {
        return this.canManageRealmDefault();
    }

    @Override
    public void requireManageRealm() {
        if (!this.canManageRealm()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canViewRealm() {
        return this.canViewRealmDefault();
    }

    @Override
    public void requireViewRealm() {
        if (!this.canViewRealm()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageIdentityProviders() {
        return this.canManageIdentityProvidersDefault();
    }

    @Override
    public boolean canViewIdentityProviders() {
        return this.canViewIdentityProvidersDefault();
    }

    @Override
    public void requireViewIdentityProviders() {
        if (!this.canViewIdentityProviders()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireManageIdentityProviders() {
        if (!this.canManageIdentityProviders()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageAuthorization() {
        return this.canManageAuthorizationDefault();
    }

    @Override
    public boolean canViewAuthorization() {
        return this.canViewAuthorizationDefault();
    }

    @Override
    public void requireManageAuthorization() {
        if (!this.canManageAuthorization()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireViewAuthorization() {
        if (!this.canViewAuthorization()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageEvents() {
        return this.canManageEventsDefault();
    }

    @Override
    public void requireManageEvents() {
        if (!this.canManageEvents()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canViewEvents() {
        return this.canViewEventsDefault();
    }

    @Override
    public void requireViewEvents() {
        if (!this.canViewEvents()) {
            throw new ForbiddenException();
        }
    }
}

