/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.utils.TotpUtils;

public class TotpBean {
    private final RealmModel realm;
    private final String totpSecret;
    private final String totpSecretEncoded;
    private final String totpSecretQrCode;
    private final boolean enabled;
    private final UriBuilder uriBuilder;
    private final List<CredentialModel> otpCredentials;

    public TotpBean(KeycloakSession session, RealmModel realm, UserModel user, UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
        this.enabled = ((OTPCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp")).isConfiguredFor(realm, user);
        this.otpCredentials = this.enabled ? session.userCredentialManager().getStoredCredentialsByType(realm, user, "otp") : Collections.EMPTY_LIST;
        this.realm = realm;
        this.totpSecret = HmacOTP.generateSecret((int)20);
        this.totpSecretEncoded = TotpUtils.encode(this.totpSecret);
        this.totpSecretQrCode = TotpUtils.qrCode(this.totpSecret, realm, user);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public String getTotpSecretEncoded() {
        return this.totpSecretEncoded;
    }

    public String getTotpSecretQrCode() {
        return this.totpSecretQrCode;
    }

    public String getManualUrl() {
        return this.uriBuilder.replaceQueryParam("mode", new Object[]{"manual"}).build(new Object[0]).toString();
    }

    public String getQrUrl() {
        return this.uriBuilder.replaceQueryParam("mode", new Object[]{"qr"}).build(new Object[0]).toString();
    }

    public OTPPolicy getPolicy() {
        return this.realm.getOTPPolicy();
    }

    public List<CredentialModel> getOtpCredentials() {
        return this.otpCredentials;
    }
}

