/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.resources.Cors;

public abstract class AbstractResourceService {
    protected final UserModel user;
    protected final AuthorizationProvider provider;
    protected final PermissionTicketStore ticketStore;
    protected final ResourceStore resourceStore;
    protected final ScopeStore scopeStore;
    protected HttpRequest request;
    protected Auth auth;

    protected AbstractResourceService(KeycloakSession session, UserModel user, Auth auth, HttpRequest request) {
        this.user = user;
        this.auth = auth;
        this.request = request;
        this.provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        this.ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        this.resourceStore = this.provider.getStoreFactory().getResourceStore();
        this.scopeStore = this.provider.getStoreFactory().getScopeStore();
    }

    protected Response cors(Response.ResponseBuilder response) {
        return Cors.add(this.request, response).auth().allowedOrigins(this.auth.getToken()).build();
    }

    public static class Client
    extends ClientRepresentation {
        public Client() {
        }

        Client(ClientModel client) {
            this.setClientId(client.getClientId());
            this.setName(client.getName());
            this.setBaseUrl(client.getBaseUrl());
        }
    }

    public static class Scope
    extends ScopeRepresentation {
        public Scope() {
        }

        Scope(org.keycloak.authorization.model.Scope scope) {
            this.setName(scope.getName());
            this.setDisplayName(scope.getDisplayName());
            this.setIconUri(scope.getIconUri());
        }
    }

    public static class Permission
    extends UserRepresentation {
        private List<String> scopes;

        public Permission() {
        }

        Permission(String userId, AuthorizationProvider provider) {
            UserModel user = provider.getKeycloakSession().users().getUserById(userId, provider.getRealm());
            this.setUsername(user.getUsername());
            this.setFirstName(user.getFirstName());
            this.setLastName(user.getLastName());
            this.setEmail(user.getEmail());
        }

        Permission(PermissionTicket ticket, AuthorizationProvider provider) {
            this(ticket.getRequester(), provider);
        }

        public Permission(String userName, String ... scopes) {
            this.setUsername(userName);
            for (String scope : scopes) {
                this.addScope(scope);
            }
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void addScope(String ... scope) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            this.scopes.addAll(Arrays.asList(scope));
        }
    }

    public static class ResourcePermission
    extends Resource {
        private Map<String, Permission> permissions;

        public ResourcePermission() {
        }

        ResourcePermission(PermissionTicket ticket, AuthorizationProvider provider) {
            super(ticket.getResource(), provider);
            this.setScopes(new HashSet());
        }

        ResourcePermission(org.keycloak.authorization.model.Resource resource, AuthorizationProvider provider) {
            super(resource, provider);
            this.setScopes(new HashSet());
        }

        public Collection<Permission> getPermissions() {
            if (this.permissions == null) {
                return null;
            }
            return this.permissions.values();
        }

        public void setPermissions(Collection<Permission> permissions) {
            for (Permission permission : permissions) {
                this.addPermission(permission.getUsername(), permission);
            }
        }

        public void addPermission(String requester, Permission permission) {
            if (this.permissions == null) {
                this.permissions = new HashMap<String, Permission>();
            }
            this.permissions.put(requester, permission);
        }

        public Permission getPermission(String requester) {
            if (this.permissions == null) {
                return null;
            }
            return this.permissions.get(requester);
        }
    }

    public static class Resource
    extends ResourceRepresentation {
        private Client client;

        public Resource() {
        }

        Resource(org.keycloak.authorization.model.Resource resource, UserModel owner, AuthorizationProvider provider) {
            this.setId(resource.getId());
            this.setName(resource.getName());
            this.setDisplayName(resource.getDisplayName());
            this.setUris(resource.getUris());
            this.setIconUri(resource.getIconUri());
            this.setScopes(resource.getScopes().stream().map(Scope::new).collect(Collectors.toSet()));
            ResourceServer resourceServer = resource.getResourceServer();
            this.client = new Client(provider.getRealm().getClientById(resourceServer.getId()));
        }

        Resource(org.keycloak.authorization.model.Resource resource, AuthorizationProvider provider) {
            this(resource, null, provider);
        }

        public Client getClient() {
            return this.client;
        }
    }
}

